
#modelnums = range(150)
import standemo
modelnums = standemo.get_modelnums()

#inits = range(3)
inits = [1]
metrics = ['elbos','err_mu','err_Sigma']

init_str = {0:'all zero',1:'Laplace init',2:'cheat mu and Sigma'}

fid = open('index.html','w')

fid.write(
"""<html><head>
<style>
p.ex1 {
  max-width: 30%;
}
</style>
</head><body>""")

fid.write('\n<p> links to sets of files:')

def getidd(init):
    idd = str(init)
    label = init_str[init]
    return idd,label

for init in inits:
    idd,label = getidd(init)
    fid.write("<p><a href=#"+idd+'>'+label+"</a>\n")

fid.write("<p>metric comparisons")
for init in inits:
    idd,label = getidd(init)
    fid.write("<p>"+label+"<ul>")
    for metric in ['elbo','err_mu','err_Sigma']:
        fid.write("<li><a href=all_experiments_"+metric+'_'+str(init)+".pdf> metric="+metric+"</a></li>")
    fid.write("</ul>\n")

fid.write("<center>\n")
for init in inits:
    fid.write("<hr>")
    idd,label = getidd(init)
    fid.write("<div id="+idd+'>'+label+'</div>\n')
    #for metric in ['elbo','err_mu','err_Sigma']:
    #fid.write("<a href=all_experiments_"+metric+'_'+str(init)+".pdf> metric="+metric+"</a>")
    #fid.write("\n")

    for modelnum in modelnums:
        fid.write("<p>"+str(modelnum)+"\n")
        fid.write("<a href=samps"+str(modelnum)+'_'+str(init)+".png>samples</a> ")
        fid.write("<a href=comp"+str(modelnum)+'_'+str(init)+".png>comparison</a> ")
        fid.write("<a href=dense"+str(modelnum)+'_'+str(init)+"_hor.png>density</a> ")
        fid.write("<a href=dense"+str(modelnum)+'_'+str(init)+"_hor.pdf>density-pdf</a> ")
        fid.write("\n<p>\n")
        for metric in metrics:
            fid.write("<img src=stan"+str(modelnum)+'_'+str(init)+'_'+metric+'.png>\n')
fid.write("</center>\n")

fid.write("</body></html>")
fid.close()
