from mynumpy import *

def T_gauss(u,v,m,S):
    # u is a set of samples from the sphere
    # v is a set of numbers in 0-1

    ndims,nsamps = u.shape
    u_norm2 = np.sum(u**2,axis=0)
    assert(np.allclose(u_norm2,1.0))

    # get target radiuses
    r = scipy.stats.ppf(v,ndims)

    return expand_dims(m,axis=1) + r * (S @ u)


