function B = project_lagrangian_sparsity(A,c)

R = abs(A);

n = length(A);

Z = double(A==0);

p.M = zeros(n);
p.L = zeros(n);

    function [g grad B] = eval(params)
        p    = unpackstruct(params,p);
        grad = unpackstruct(params*0,p);
        
        M = p.M;
        L = p.L;
        [U S V] = svd(R + M - L.*Z);
        
        S(S>c) = c;
        D = U*S*V';
                
        g  = .5*norm(D-R,'fro')^2 + sum(sum(L.*Z.*D)) - sum(sum(M.*D));
        %g  = .5*norm(D-R,'fro')^2 - sum(sum(M.*D));
        grad.M = -D;
        grad.L = Z.*D;
        
        B = D.*sign(A);
        
        % want to maximize, not minimize
        g    = -g;
        grad = -packstruct(grad);
    end



%options = optimset('Display','iter','GradObj','on','Algorithm','active-set');
%M = fmincon(@eval,M,[],[],[],[],0*M,inf+M,[],options);

options = [];
options.corrections = 5;
options.numDiff = 0;
options.MaxIter = 1e6;

params = packstruct(p);
lb.M = zeros(size(p.M)); lb.L = -inf(size(p.L)); lb = packstruct(lb);
ub.M = inf(size(p.M));   ub.L =  inf(size(p.M)); ub = packstruct(ub);

M = minConf_TMP(@eval,params,lb,ub,options);

[~,~,B] = eval(M);

end