function B = project_lagrangian(A,c)

R = abs(A);

n = length(A);

M = zeros(n);

    function [g dM B] = eval(M)
        M = reshape(M,n,n);
        [U S V] = svd(R + M);
        
        S(S>c) = c;
        D = U*S*V';
                
        g  = .5*norm(D-R,'fro')^2 - sum(sum(M.*D));
        dM = -D;
        
        B = D.*sign(A);
        dM = dM(:);
        
        % want to maximize, not minimize
        g  = -g;
        dM = -dM;
    end



%options = optimset('Display','iter','GradObj','on','Algorithm','active-set');
%M = fmincon(@eval,M,[],[],[],[],0*M,inf+M,[],options);

options = [];
options.corrections = 5;

M = M(:);
M = minConf_TMP(@eval,M,0*M,M+inf,options);

[~,~,B] = eval(M);

end