function toolboxGenDoc
% Generate documentation, must run from dir toolbox.
%
% 1) Make sure to run toolboxUpdateHeader.m
% 2) Update history.txt appropriately, including w current version
% 3) Update overview.html file with the version/data/link to zip:
%     edit external/m2html/templates/frame-piotr/overview.html
%
% USAGE
%  toolboxGenDoc
%
% INPUTS
%
% OUTPUTS
%
% EXAMPLE
%
% See also
%
% Piotr's Image&Video Toolbox      Version 2.41
% Copyright 2009 Piotr Dollar.  [pdollar-at-caltech.edu]
% Please email me if you find bugs, or have suggestions or questions!
% Licensed under the Lesser GPL [see external/lgpl.txt]

% Requires external/m2html to be in path.
cd(fileparts(mfilename('fullpath'))); cd('../');
addpath([pwd '/external/m2html']);

% delete old doc
delete('doc/*.*');
delete('doc/classify/*.*');
delete('doc/filters/*.*');
delete('doc/images/*.*');
delete('doc/matlab/*.*');

% run m2html
params = {'mfiles',{'classify','images','filters','matlab'}};
params = [params {'htmldir','doc','recursive','on','source','off'}];
params = [params {'template','frame-piotr','index','menu','global','on'}];
m2html(params{:});

% copy custom menu.html
copyfile('external\m2html\templates\menu-for-frame-piotr.html','doc/menu.html')

% copy history file
copyfile('external\history.txt','doc/history.txt')

% remove links to .svn and private in the menu.html files
d = { './doc' };
while ~isempty(d)
  dTmp = dir(d{1});
  for i = 1 : length(dTmp)
    name = dTmp(i).name;
    if strcmp( name,'.') || strcmp( name,'..'); continue; end
    if dTmp(i).isdir; d{end+1} = [ d{1} '/' name ]; continue; end %#ok<AGROW>
    if ~strcmp( name,'menu.html'); continue; end
    fid = fopen( [ d{1} '/' name ], 'r' ); c = fread(fid, '*char')'; fclose( fid );
    c = regexprep( c, '<li>([^<]*[<]?[^<]*)\.svn([^<]*[<]?[^<]*)</li>', '');
    c = regexprep( c, '<li>([^<]*[<]?[^<]*)private([^<]*[<]?[^<]*)</li>', '');
    fid = fopen( [ d{1} '/' name ], 'w' ); fwrite( fid, c ); fclose( fid );
  end
  d(1) = [];
end

% remove /private directories
rmdir('doc/classify/private','s')
rmdir('doc/images/private','s')

% postprocess each html file
dirs = {'classify','images','filters','matlab'};
for d=1:length(dirs)
  fNames = dir(['doc/' dirs{d} '/*.html']); fNames={fNames.name};
  for j=1:length(fNames), postProcess( ['doc/' dirs{d} '/' fNames{j} ]); end
end

end

function postProcess( fName )
lines=readFile(fName);
assert(strcmp(lines{end-1},'</body>') && strcmp(lines{end},'</html>'));
% remove m2html datestamp (if present)
assert(strcmp(lines{end-2}(1:22),'<hr><address>Generated'));
if( strcmp(lines{end-2}(1:25),'<hr><address>Generated on'))
  lines{end-2}=regexprep(lines{end-2}, ...
    '<hr><address>Generated on .* by','<hr><address>Generated by');
end
% insert Google Analytics snippet to end of file
ga={ '';
  '<!-- Start of Google Analytics Code -->';
  '<script type="text/javascript">';
  'var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");';
  'document.write(unescape("%3Cscript src=''" + gaJsHost + "google-analytics.com/ga.js'' type=''text/javascript''%3E%3C/script%3E"));';
  '</script>';
  '<script type="text/javascript">';
  'var pageTracker = _gat._getTracker("UA-4884268-1");';
  'pageTracker._initData();';
  'pageTracker._trackPageview();';
  '</script>';
  '<!-- end of Google Analytics Code -->';
  '' };
lines = [lines(1:end-3); ga; lines(end-2:end)];
% write file
writeFile( fName, lines );
end

function lines = readFile( fName )
fid = fopen( fName, 'rt' ); assert(fid~=-1);
lines=cell(10000,1); n=0;
while( 1 )
  n=n+1; lines{n}=fgetl(fid);
  if( ~ischar(lines{n}) ), break; end
end
fclose(fid); n=n-1; lines=lines(1:n);
end

function writeFile( fName, lines )
fid = fopen( fName, 'wt' );
for i=1:length(lines); fprintf( fid, '%s\n', lines{i} ); end
fclose(fid);
end
