/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2011 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Michael Wallner <mike@php.net>                               |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#ifndef PHP_HASH_WHIRLPOOL_TABLES_H
#define PHP_HASH_WHIRLPOOL_TABLES_H

#define R 10

static const php_hash_uint64 rc[R + 1] = {
    L64(0x0000000000000000),
    L64(0x1823c6e887b8014f),
    L64(0x36a6d2f5796f9152),
    L64(0x60bc9b8ea30c7b35),
    L64(0x1de0d7c22e4bfe57),
    L64(0x157737e59ff04ada),
    L64(0x58c9290ab1a06b85),
    L64(0xbd5d10f4cb3e0567),
    L64(0xe427418ba77d95d8),
    L64(0xfbee7c66dd17479e),
    L64(0xca2dbf07ad5a8333),
};

static const php_hash_uint64 C0[256] = {
    L64(0x18186018c07830d8), L64(0x23238c2305af4626), L64(0xc6c63fc67ef991b8), L64(0xe8e887e8136fcdfb),
    L64(0x878726874ca113cb), L64(0xb8b8dab8a9626d11), L64(0x0101040108050209), L64(0x4f4f214f426e9e0d),
    L64(0x3636d836adee6c9b), L64(0xa6a6a2a6590451ff), L64(0xd2d26fd2debdb90c), L64(0xf5f5f3f5fb06f70e),
    L64(0x7979f979ef80f296), L64(0x6f6fa16f5fcede30), L64(0x91917e91fcef3f6d), L64(0x52525552aa07a4f8),
    L64(0x60609d6027fdc047), L64(0xbcbccabc89766535), L64(0x9b9b569baccd2b37), L64(0x8e8e028e048c018a),
    L64(0xa3a3b6a371155bd2), L64(0x0c0c300c603c186c), L64(0x7b7bf17bff8af684), L64(0x3535d435b5e16a80),
    L64(0x1d1d741de8693af5), L64(0xe0e0a7e05347ddb3), L64(0xd7d77bd7f6acb321), L64(0xc2c22fc25eed999c),
    L64(0x2e2eb82e6d965c43), L64(0x4b4b314b627a9629), L64(0xfefedffea321e15d), L64(0x575741578216aed5),
    L64(0x15155415a8412abd), L64(0x7777c1779fb6eee8), L64(0x3737dc37a5eb6e92), L64(0xe5e5b3e57b56d79e),
    L64(0x9f9f469f8cd92313), L64(0xf0f0e7f0d317fd23), L64(0x4a4a354a6a7f9420), L64(0xdada4fda9e95a944),
    L64(0x58587d58fa25b0a2), L64(0xc9c903c906ca8fcf), L64(0x2929a429558d527c), L64(0x0a0a280a5022145a),
    L64(0xb1b1feb1e14f7f50), L64(0xa0a0baa0691a5dc9), L64(0x6b6bb16b7fdad614), L64(0x85852e855cab17d9),
    L64(0xbdbdcebd8173673c), L64(0x5d5d695dd234ba8f), L64(0x1010401080502090), L64(0xf4f4f7f4f303f507),
    L64(0xcbcb0bcb16c08bdd), L64(0x3e3ef83eedc67cd3), L64(0x0505140528110a2d), L64(0x676781671fe6ce78),
    L64(0xe4e4b7e47353d597), L64(0x27279c2725bb4e02), L64(0x4141194132588273), L64(0x8b8b168b2c9d0ba7),
    L64(0xa7a7a6a7510153f6), L64(0x7d7de97dcf94fab2), L64(0x95956e95dcfb3749), L64(0xd8d847d88e9fad56),
    L64(0xfbfbcbfb8b30eb70), L64(0xeeee9fee2371c1cd), L64(0x7c7ced7cc791f8bb), L64(0x6666856617e3cc71),
    L64(0xdddd53dda68ea77b), L64(0x17175c17b84b2eaf), L64(0x4747014702468e45), L64(0x9e9e429e84dc211a),
    L64(0xcaca0fca1ec589d4), L64(0x2d2db42d75995a58), L64(0xbfbfc6bf9179632e), L64(0x07071c07381b0e3f),
    L64(0xadad8ead012347ac), L64(0x5a5a755aea2fb4b0), L64(0x838336836cb51bef), L64(0x3333cc3385ff66b6),
    L64(0x636391633ff2c65c), L64(0x02020802100a0412), L64(0xaaaa92aa39384993), L64(0x7171d971afa8e2de),
    L64(0xc8c807c80ecf8dc6), L64(0x19196419c87d32d1), L64(0x494939497270923b), L64(0xd9d943d9869aaf5f),
    L64(0xf2f2eff2c31df931), L64(0xe3e3abe34b48dba8), L64(0x5b5b715be22ab6b9), L64(0x88881a8834920dbc),
    L64(0x9a9a529aa4c8293e), L64(0x262698262dbe4c0b), L64(0x3232c8328dfa64bf), L64(0xb0b0fab0e94a7d59),
    L64(0xe9e983e91b6acff2), L64(0x0f0f3c0f78331e77), L64(0xd5d573d5e6a6b733), L64(0x80803a8074ba1df4),
    L64(0xbebec2be997c6127), L64(0xcdcd13cd26de87eb), L64(0x3434d034bde46889), L64(0x48483d487a759032),
    L64(0xffffdbffab24e354), L64(0x7a7af57af78ff48d), L64(0x90907a90f4ea3d64), L64(0x5f5f615fc23ebe9d),
    L64(0x202080201da0403d), L64(0x6868bd6867d5d00f), L64(0x1a1a681ad07234ca), L64(0xaeae82ae192c41b7),
    L64(0xb4b4eab4c95e757d), L64(0x54544d549a19a8ce), L64(0x93937693ece53b7f), L64(0x222288220daa442f),
    L64(0x64648d6407e9c863), L64(0xf1f1e3f1db12ff2a), L64(0x7373d173bfa2e6cc), L64(0x12124812905a2482),
    L64(0x40401d403a5d807a), L64(0x0808200840281048), L64(0xc3c32bc356e89b95), L64(0xecec97ec337bc5df),
    L64(0xdbdb4bdb9690ab4d), L64(0xa1a1bea1611f5fc0), L64(0x8d8d0e8d1c830791), L64(0x3d3df43df5c97ac8),
    L64(0x97976697ccf1335b), L64(0x0000000000000000), L64(0xcfcf1bcf36d483f9), L64(0x2b2bac2b4587566e),
    L64(0x7676c57697b3ece1), L64(0x8282328264b019e6), L64(0xd6d67fd6fea9b128), L64(0x1b1b6c1bd87736c3),
    L64(0xb5b5eeb5c15b7774), L64(0xafaf86af112943be), L64(0x6a6ab56a77dfd41d), L64(0x50505d50ba0da0ea),
    L64(0x45450945124c8a57), L64(0xf3f3ebf3cb18fb38), L64(0x3030c0309df060ad), L64(0xefef9bef2b74c3c4),
    L64(0x3f3ffc3fe5c37eda), L64(0x55554955921caac7), L64(0xa2a2b2a2791059db), L64(0xeaea8fea0365c9e9),
    L64(0x656589650fecca6a), L64(0xbabad2bab9686903), L64(0x2f2fbc2f65935e4a), L64(0xc0c027c04ee79d8e),
    L64(0xdede5fdebe81a160), L64(0x1c1c701ce06c38fc), L64(0xfdfdd3fdbb2ee746), L64(0x4d4d294d52649a1f),
    L64(0x92927292e4e03976), L64(0x7575c9758fbceafa), L64(0x06061806301e0c36), L64(0x8a8a128a249809ae),
    L64(0xb2b2f2b2f940794b), L64(0xe6e6bfe66359d185), L64(0x0e0e380e70361c7e), L64(0x1f1f7c1ff8633ee7),
    L64(0x6262956237f7c455), L64(0xd4d477d4eea3b53a), L64(0xa8a89aa829324d81), L64(0x96966296c4f43152),
    L64(0xf9f9c3f99b3aef62), L64(0xc5c533c566f697a3), L64(0x2525942535b14a10), L64(0x59597959f220b2ab),
    L64(0x84842a8454ae15d0), L64(0x7272d572b7a7e4c5), L64(0x3939e439d5dd72ec), L64(0x4c4c2d4c5a619816),
    L64(0x5e5e655eca3bbc94), L64(0x7878fd78e785f09f), L64(0x3838e038ddd870e5), L64(0x8c8c0a8c14860598),
    L64(0xd1d163d1c6b2bf17), L64(0xa5a5aea5410b57e4), L64(0xe2e2afe2434dd9a1), L64(0x616199612ff8c24e),
    L64(0xb3b3f6b3f1457b42), L64(0x2121842115a54234), L64(0x9c9c4a9c94d62508), L64(0x1e1e781ef0663cee),
    L64(0x4343114322528661), L64(0xc7c73bc776fc93b1), L64(0xfcfcd7fcb32be54f), L64(0x0404100420140824),
    L64(0x51515951b208a2e3), L64(0x99995e99bcc72f25), L64(0x6d6da96d4fc4da22), L64(0x0d0d340d68391a65),
    L64(0xfafacffa8335e979), L64(0xdfdf5bdfb684a369), L64(0x7e7ee57ed79bfca9), L64(0x242490243db44819),
    L64(0x3b3bec3bc5d776fe), L64(0xabab96ab313d4b9a), L64(0xcece1fce3ed181f0), L64(0x1111441188552299),
    L64(0x8f8f068f0c890383), L64(0x4e4e254e4a6b9c04), L64(0xb7b7e6b7d1517366), L64(0xebeb8beb0b60cbe0),
    L64(0x3c3cf03cfdcc78c1), L64(0x81813e817cbf1ffd), L64(0x94946a94d4fe3540), L64(0xf7f7fbf7eb0cf31c),
    L64(0xb9b9deb9a1676f18), L64(0x13134c13985f268b), L64(0x2c2cb02c7d9c5851), L64(0xd3d36bd3d6b8bb05),
    L64(0xe7e7bbe76b5cd38c), L64(0x6e6ea56e57cbdc39), L64(0xc4c437c46ef395aa), L64(0x03030c03180f061b),
    L64(0x565645568a13acdc), L64(0x44440d441a49885e), L64(0x7f7fe17fdf9efea0), L64(0xa9a99ea921374f88),
    L64(0x2a2aa82a4d825467), L64(0xbbbbd6bbb16d6b0a), L64(0xc1c123c146e29f87), L64(0x53535153a202a6f1),
    L64(0xdcdc57dcae8ba572), L64(0x0b0b2c0b58271653), L64(0x9d9d4e9d9cd32701), L64(0x6c6cad6c47c1d82b),
    L64(0x3131c43195f562a4), L64(0x7474cd7487b9e8f3), L64(0xf6f6fff6e309f115), L64(0x464605460a438c4c),
    L64(0xacac8aac092645a5), L64(0x89891e893c970fb5), L64(0x14145014a04428b4), L64(0xe1e1a3e15b42dfba),
    L64(0x16165816b04e2ca6), L64(0x3a3ae83acdd274f7), L64(0x6969b9696fd0d206), L64(0x09092409482d1241),
    L64(0x7070dd70a7ade0d7), L64(0xb6b6e2b6d954716f), L64(0xd0d067d0ceb7bd1e), L64(0xeded93ed3b7ec7d6),
    L64(0xcccc17cc2edb85e2), L64(0x424215422a578468), L64(0x98985a98b4c22d2c), L64(0xa4a4aaa4490e55ed),
    L64(0x2828a0285d885075), L64(0x5c5c6d5cda31b886), L64(0xf8f8c7f8933fed6b), L64(0x8686228644a411c2),
};

static const php_hash_uint64 C1[256] = {
    L64(0xd818186018c07830), L64(0x2623238c2305af46), L64(0xb8c6c63fc67ef991), L64(0xfbe8e887e8136fcd),
    L64(0xcb878726874ca113), L64(0x11b8b8dab8a9626d), L64(0x0901010401080502), L64(0x0d4f4f214f426e9e),
    L64(0x9b3636d836adee6c), L64(0xffa6a6a2a6590451), L64(0x0cd2d26fd2debdb9), L64(0x0ef5f5f3f5fb06f7),
    L64(0x967979f979ef80f2), L64(0x306f6fa16f5fcede), L64(0x6d91917e91fcef3f), L64(0xf852525552aa07a4),
    L64(0x4760609d6027fdc0), L64(0x35bcbccabc897665), L64(0x379b9b569baccd2b), L64(0x8a8e8e028e048c01),
    L64(0xd2a3a3b6a371155b), L64(0x6c0c0c300c603c18), L64(0x847b7bf17bff8af6), L64(0x803535d435b5e16a),
    L64(0xf51d1d741de8693a), L64(0xb3e0e0a7e05347dd), L64(0x21d7d77bd7f6acb3), L64(0x9cc2c22fc25eed99),
    L64(0x432e2eb82e6d965c), L64(0x294b4b314b627a96), L64(0x5dfefedffea321e1), L64(0xd5575741578216ae),
    L64(0xbd15155415a8412a), L64(0xe87777c1779fb6ee), L64(0x923737dc37a5eb6e), L64(0x9ee5e5b3e57b56d7),
    L64(0x139f9f469f8cd923), L64(0x23f0f0e7f0d317fd), L64(0x204a4a354a6a7f94), L64(0x44dada4fda9e95a9),
    L64(0xa258587d58fa25b0), L64(0xcfc9c903c906ca8f), L64(0x7c2929a429558d52), L64(0x5a0a0a280a502214),
    L64(0x50b1b1feb1e14f7f), L64(0xc9a0a0baa0691a5d), L64(0x146b6bb16b7fdad6), L64(0xd985852e855cab17),
    L64(0x3cbdbdcebd817367), L64(0x8f5d5d695dd234ba), L64(0x9010104010805020), L64(0x07f4f4f7f4f303f5),
    L64(0xddcbcb0bcb16c08b), L64(0xd33e3ef83eedc67c), L64(0x2d0505140528110a), L64(0x78676781671fe6ce),
    L64(0x97e4e4b7e47353d5), L64(0x0227279c2725bb4e), L64(0x7341411941325882), L64(0xa78b8b168b2c9d0b),
    L64(0xf6a7a7a6a7510153), L64(0xb27d7de97dcf94fa), L64(0x4995956e95dcfb37), L64(0x56d8d847d88e9fad),
    L64(0x70fbfbcbfb8b30eb), L64(0xcdeeee9fee2371c1), L64(0xbb7c7ced7cc791f8), L64(0x716666856617e3cc),
    L64(0x7bdddd53dda68ea7), L64(0xaf17175c17b84b2e), L64(0x454747014702468e), L64(0x1a9e9e429e84dc21),
    L64(0xd4caca0fca1ec589), L64(0x582d2db42d75995a), L64(0x2ebfbfc6bf917963), L64(0x3f07071c07381b0e),
    L64(0xacadad8ead012347), L64(0xb05a5a755aea2fb4), L64(0xef838336836cb51b), L64(0xb63333cc3385ff66),
    L64(0x5c636391633ff2c6), L64(0x1202020802100a04), L64(0x93aaaa92aa393849), L64(0xde7171d971afa8e2),
    L64(0xc6c8c807c80ecf8d), L64(0xd119196419c87d32), L64(0x3b49493949727092), L64(0x5fd9d943d9869aaf),
    L64(0x31f2f2eff2c31df9), L64(0xa8e3e3abe34b48db), L64(0xb95b5b715be22ab6), L64(0xbc88881a8834920d),
    L64(0x3e9a9a529aa4c829), L64(0x0b262698262dbe4c), L64(0xbf3232c8328dfa64), L64(0x59b0b0fab0e94a7d),
    L64(0xf2e9e983e91b6acf), L64(0x770f0f3c0f78331e), L64(0x33d5d573d5e6a6b7), L64(0xf480803a8074ba1d),
    L64(0x27bebec2be997c61), L64(0xebcdcd13cd26de87), L64(0x893434d034bde468), L64(0x3248483d487a7590),
    L64(0x54ffffdbffab24e3), L64(0x8d7a7af57af78ff4), L64(0x6490907a90f4ea3d), L64(0x9d5f5f615fc23ebe),
    L64(0x3d202080201da040), L64(0x0f6868bd6867d5d0), L64(0xca1a1a681ad07234), L64(0xb7aeae82ae192c41),
    L64(0x7db4b4eab4c95e75), L64(0xce54544d549a19a8), L64(0x7f93937693ece53b), L64(0x2f222288220daa44),
    L64(0x6364648d6407e9c8), L64(0x2af1f1e3f1db12ff), L64(0xcc7373d173bfa2e6), L64(0x8212124812905a24),
    L64(0x7a40401d403a5d80), L64(0x4808082008402810), L64(0x95c3c32bc356e89b), L64(0xdfecec97ec337bc5),
    L64(0x4ddbdb4bdb9690ab), L64(0xc0a1a1bea1611f5f), L64(0x918d8d0e8d1c8307), L64(0xc83d3df43df5c97a),
    L64(0x5b97976697ccf133), L64(0x0000000000000000), L64(0xf9cfcf1bcf36d483), L64(0x6e2b2bac2b458756),
    L64(0xe17676c57697b3ec), L64(0xe68282328264b019), L64(0x28d6d67fd6fea9b1), L64(0xc31b1b6c1bd87736),
    L64(0x74b5b5eeb5c15b77), L64(0xbeafaf86af112943), L64(0x1d6a6ab56a77dfd4), L64(0xea50505d50ba0da0),
    L64(0x5745450945124c8a), L64(0x38f3f3ebf3cb18fb), L64(0xad3030c0309df060), L64(0xc4efef9bef2b74c3),
    L64(0xda3f3ffc3fe5c37e), L64(0xc755554955921caa), L64(0xdba2a2b2a2791059), L64(0xe9eaea8fea0365c9),
    L64(0x6a656589650fecca), L64(0x03babad2bab96869), L64(0x4a2f2fbc2f65935e), L64(0x8ec0c027c04ee79d),
    L64(0x60dede5fdebe81a1), L64(0xfc1c1c701ce06c38), L64(0x46fdfdd3fdbb2ee7), L64(0x1f4d4d294d52649a),
    L64(0x7692927292e4e039), L64(0xfa7575c9758fbcea), L64(0x3606061806301e0c), L64(0xae8a8a128a249809),
    L64(0x4bb2b2f2b2f94079), L64(0x85e6e6bfe66359d1), L64(0x7e0e0e380e70361c), L64(0xe71f1f7c1ff8633e),
    L64(0x556262956237f7c4), L64(0x3ad4d477d4eea3b5), L64(0x81a8a89aa829324d), L64(0x5296966296c4f431),
    L64(0x62f9f9c3f99b3aef), L64(0xa3c5c533c566f697), L64(0x102525942535b14a), L64(0xab59597959f220b2),
    L64(0xd084842a8454ae15), L64(0xc57272d572b7a7e4), L64(0xec3939e439d5dd72), L64(0x164c4c2d4c5a6198),
    L64(0x945e5e655eca3bbc), L64(0x9f7878fd78e785f0), L64(0xe53838e038ddd870), L64(0x988c8c0a8c148605),
    L64(0x17d1d163d1c6b2bf), L64(0xe4a5a5aea5410b57), L64(0xa1e2e2afe2434dd9), L64(0x4e616199612ff8c2),
    L64(0x42b3b3f6b3f1457b), L64(0x342121842115a542), L64(0x089c9c4a9c94d625), L64(0xee1e1e781ef0663c),
    L64(0x6143431143225286), L64(0xb1c7c73bc776fc93), L64(0x4ffcfcd7fcb32be5), L64(0x2404041004201408),
    L64(0xe351515951b208a2), L64(0x2599995e99bcc72f), L64(0x226d6da96d4fc4da), L64(0x650d0d340d68391a),
    L64(0x79fafacffa8335e9), L64(0x69dfdf5bdfb684a3), L64(0xa97e7ee57ed79bfc), L64(0x19242490243db448),
    L64(0xfe3b3bec3bc5d776), L64(0x9aabab96ab313d4b), L64(0xf0cece1fce3ed181), L64(0x9911114411885522),
    L64(0x838f8f068f0c8903), L64(0x044e4e254e4a6b9c), L64(0x66b7b7e6b7d15173), L64(0xe0ebeb8beb0b60cb),
    L64(0xc13c3cf03cfdcc78), L64(0xfd81813e817cbf1f), L64(0x4094946a94d4fe35), L64(0x1cf7f7fbf7eb0cf3),
    L64(0x18b9b9deb9a1676f), L64(0x8b13134c13985f26), L64(0x512c2cb02c7d9c58), L64(0x05d3d36bd3d6b8bb),
    L64(0x8ce7e7bbe76b5cd3), L64(0x396e6ea56e57cbdc), L64(0xaac4c437c46ef395), L64(0x1b03030c03180f06),
    L64(0xdc565645568a13ac), L64(0x5e44440d441a4988), L64(0xa07f7fe17fdf9efe), L64(0x88a9a99ea921374f),
    L64(0x672a2aa82a4d8254), L64(0x0abbbbd6bbb16d6b), L64(0x87c1c123c146e29f), L64(0xf153535153a202a6),
    L64(0x72dcdc57dcae8ba5), L64(0x530b0b2c0b582716), L64(0x019d9d4e9d9cd327), L64(0x2b6c6cad6c47c1d8),
    L64(0xa43131c43195f562), L64(0xf37474cd7487b9e8), L64(0x15f6f6fff6e309f1), L64(0x4c464605460a438c),
    L64(0xa5acac8aac092645), L64(0xb589891e893c970f), L64(0xb414145014a04428), L64(0xbae1e1a3e15b42df),
    L64(0xa616165816b04e2c), L64(0xf73a3ae83acdd274), L64(0x066969b9696fd0d2), L64(0x4109092409482d12),
    L64(0xd77070dd70a7ade0), L64(0x6fb6b6e2b6d95471), L64(0x1ed0d067d0ceb7bd), L64(0xd6eded93ed3b7ec7),
    L64(0xe2cccc17cc2edb85), L64(0x68424215422a5784), L64(0x2c98985a98b4c22d), L64(0xeda4a4aaa4490e55),
    L64(0x752828a0285d8850), L64(0x865c5c6d5cda31b8), L64(0x6bf8f8c7f8933fed), L64(0xc28686228644a411),
};

static const php_hash_uint64 C2[256] = {
    L64(0x30d818186018c078), L64(0x462623238c2305af), L64(0x91b8c6c63fc67ef9), L64(0xcdfbe8e887e8136f),
    L64(0x13cb878726874ca1), L64(0x6d11b8b8dab8a962), L64(0x0209010104010805), L64(0x9e0d4f4f214f426e),
    L64(0x6c9b3636d836adee), L64(0x51ffa6a6a2a65904), L64(0xb90cd2d26fd2debd), L64(0xf70ef5f5f3f5fb06),
    L64(0xf2967979f979ef80), L64(0xde306f6fa16f5fce), L64(0x3f6d91917e91fcef), L64(0xa4f852525552aa07),
    L64(0xc04760609d6027fd), L64(0x6535bcbccabc8976), L64(0x2b379b9b569baccd), L64(0x018a8e8e028e048c),
    L64(0x5bd2a3a3b6a37115), L64(0x186c0c0c300c603c), L64(0xf6847b7bf17bff8a), L64(0x6a803535d435b5e1),
    L64(0x3af51d1d741de869), L64(0xddb3e0e0a7e05347), L64(0xb321d7d77bd7f6ac), L64(0x999cc2c22fc25eed),
    L64(0x5c432e2eb82e6d96), L64(0x96294b4b314b627a), L64(0xe15dfefedffea321), L64(0xaed5575741578216),
    L64(0x2abd15155415a841), L64(0xeee87777c1779fb6), L64(0x6e923737dc37a5eb), L64(0xd79ee5e5b3e57b56),
    L64(0x23139f9f469f8cd9), L64(0xfd23f0f0e7f0d317), L64(0x94204a4a354a6a7f), L64(0xa944dada4fda9e95),
    L64(0xb0a258587d58fa25), L64(0x8fcfc9c903c906ca), L64(0x527c2929a429558d), L64(0x145a0a0a280a5022),
    L64(0x7f50b1b1feb1e14f), L64(0x5dc9a0a0baa0691a), L64(0xd6146b6bb16b7fda), L64(0x17d985852e855cab),
    L64(0x673cbdbdcebd8173), L64(0xba8f5d5d695dd234), L64(0x2090101040108050), L64(0xf507f4f4f7f4f303),
    L64(0x8bddcbcb0bcb16c0), L64(0x7cd33e3ef83eedc6), L64(0x0a2d050514052811), L64(0xce78676781671fe6),
    L64(0xd597e4e4b7e47353), L64(0x4e0227279c2725bb), L64(0x8273414119413258), L64(0x0ba78b8b168b2c9d),
    L64(0x53f6a7a7a6a75101), L64(0xfab27d7de97dcf94), L64(0x374995956e95dcfb), L64(0xad56d8d847d88e9f),
    L64(0xeb70fbfbcbfb8b30), L64(0xc1cdeeee9fee2371), L64(0xf8bb7c7ced7cc791), L64(0xcc716666856617e3),
    L64(0xa77bdddd53dda68e), L64(0x2eaf17175c17b84b), L64(0x8e45474701470246), L64(0x211a9e9e429e84dc),
    L64(0x89d4caca0fca1ec5), L64(0x5a582d2db42d7599), L64(0x632ebfbfc6bf9179), L64(0x0e3f07071c07381b),
    L64(0x47acadad8ead0123), L64(0xb4b05a5a755aea2f), L64(0x1bef838336836cb5), L64(0x66b63333cc3385ff),
    L64(0xc65c636391633ff2), L64(0x041202020802100a), L64(0x4993aaaa92aa3938), L64(0xe2de7171d971afa8),
    L64(0x8dc6c8c807c80ecf), L64(0x32d119196419c87d), L64(0x923b494939497270), L64(0xaf5fd9d943d9869a),
    L64(0xf931f2f2eff2c31d), L64(0xdba8e3e3abe34b48), L64(0xb6b95b5b715be22a), L64(0x0dbc88881a883492),
    L64(0x293e9a9a529aa4c8), L64(0x4c0b262698262dbe), L64(0x64bf3232c8328dfa), L64(0x7d59b0b0fab0e94a),
    L64(0xcff2e9e983e91b6a), L64(0x1e770f0f3c0f7833), L64(0xb733d5d573d5e6a6), L64(0x1df480803a8074ba),
    L64(0x6127bebec2be997c), L64(0x87ebcdcd13cd26de), L64(0x68893434d034bde4), L64(0x903248483d487a75),
    L64(0xe354ffffdbffab24), L64(0xf48d7a7af57af78f), L64(0x3d6490907a90f4ea), L64(0xbe9d5f5f615fc23e),
    L64(0x403d202080201da0), L64(0xd00f6868bd6867d5), L64(0x34ca1a1a681ad072), L64(0x41b7aeae82ae192c),
    L64(0x757db4b4eab4c95e), L64(0xa8ce54544d549a19), L64(0x3b7f93937693ece5), L64(0x442f222288220daa),
    L64(0xc86364648d6407e9), L64(0xff2af1f1e3f1db12), L64(0xe6cc7373d173bfa2), L64(0x248212124812905a),
    L64(0x807a40401d403a5d), L64(0x1048080820084028), L64(0x9b95c3c32bc356e8), L64(0xc5dfecec97ec337b),
    L64(0xab4ddbdb4bdb9690), L64(0x5fc0a1a1bea1611f), L64(0x07918d8d0e8d1c83), L64(0x7ac83d3df43df5c9),
    L64(0x335b97976697ccf1), L64(0x0000000000000000), L64(0x83f9cfcf1bcf36d4), L64(0x566e2b2bac2b4587),
    L64(0xece17676c57697b3), L64(0x19e68282328264b0), L64(0xb128d6d67fd6fea9), L64(0x36c31b1b6c1bd877),
    L64(0x7774b5b5eeb5c15b), L64(0x43beafaf86af1129), L64(0xd41d6a6ab56a77df), L64(0xa0ea50505d50ba0d),
    L64(0x8a5745450945124c), L64(0xfb38f3f3ebf3cb18), L64(0x60ad3030c0309df0), L64(0xc3c4efef9bef2b74),
    L64(0x7eda3f3ffc3fe5c3), L64(0xaac755554955921c), L64(0x59dba2a2b2a27910), L64(0xc9e9eaea8fea0365),
    L64(0xca6a656589650fec), L64(0x6903babad2bab968), L64(0x5e4a2f2fbc2f6593), L64(0x9d8ec0c027c04ee7),
    L64(0xa160dede5fdebe81), L64(0x38fc1c1c701ce06c), L64(0xe746fdfdd3fdbb2e), L64(0x9a1f4d4d294d5264),
    L64(0x397692927292e4e0), L64(0xeafa7575c9758fbc), L64(0x0c3606061806301e), L64(0x09ae8a8a128a2498),
    L64(0x794bb2b2f2b2f940), L64(0xd185e6e6bfe66359), L64(0x1c7e0e0e380e7036), L64(0x3ee71f1f7c1ff863),
    L64(0xc4556262956237f7), L64(0xb53ad4d477d4eea3), L64(0x4d81a8a89aa82932), L64(0x315296966296c4f4),
    L64(0xef62f9f9c3f99b3a), L64(0x97a3c5c533c566f6), L64(0x4a102525942535b1), L64(0xb2ab59597959f220),
    L64(0x15d084842a8454ae), L64(0xe4c57272d572b7a7), L64(0x72ec3939e439d5dd), L64(0x98164c4c2d4c5a61),
    L64(0xbc945e5e655eca3b), L64(0xf09f7878fd78e785), L64(0x70e53838e038ddd8), L64(0x05988c8c0a8c1486),
    L64(0xbf17d1d163d1c6b2), L64(0x57e4a5a5aea5410b), L64(0xd9a1e2e2afe2434d), L64(0xc24e616199612ff8),
    L64(0x7b42b3b3f6b3f145), L64(0x42342121842115a5), L64(0x25089c9c4a9c94d6), L64(0x3cee1e1e781ef066),
    L64(0x8661434311432252), L64(0x93b1c7c73bc776fc), L64(0xe54ffcfcd7fcb32b), L64(0x0824040410042014),
    L64(0xa2e351515951b208), L64(0x2f2599995e99bcc7), L64(0xda226d6da96d4fc4), L64(0x1a650d0d340d6839),
    L64(0xe979fafacffa8335), L64(0xa369dfdf5bdfb684), L64(0xfca97e7ee57ed79b), L64(0x4819242490243db4),
    L64(0x76fe3b3bec3bc5d7), L64(0x4b9aabab96ab313d), L64(0x81f0cece1fce3ed1), L64(0x2299111144118855),
    L64(0x03838f8f068f0c89), L64(0x9c044e4e254e4a6b), L64(0x7366b7b7e6b7d151), L64(0xcbe0ebeb8beb0b60),
    L64(0x78c13c3cf03cfdcc), L64(0x1ffd81813e817cbf), L64(0x354094946a94d4fe), L64(0xf31cf7f7fbf7eb0c),
    L64(0x6f18b9b9deb9a167), L64(0x268b13134c13985f), L64(0x58512c2cb02c7d9c), L64(0xbb05d3d36bd3d6b8),
    L64(0xd38ce7e7bbe76b5c), L64(0xdc396e6ea56e57cb), L64(0x95aac4c437c46ef3), L64(0x061b03030c03180f),
    L64(0xacdc565645568a13), L64(0x885e44440d441a49), L64(0xfea07f7fe17fdf9e), L64(0x4f88a9a99ea92137),
    L64(0x54672a2aa82a4d82), L64(0x6b0abbbbd6bbb16d), L64(0x9f87c1c123c146e2), L64(0xa6f153535153a202),
    L64(0xa572dcdc57dcae8b), L64(0x16530b0b2c0b5827), L64(0x27019d9d4e9d9cd3), L64(0xd82b6c6cad6c47c1),
    L64(0x62a43131c43195f5), L64(0xe8f37474cd7487b9), L64(0xf115f6f6fff6e309), L64(0x8c4c464605460a43),
    L64(0x45a5acac8aac0926), L64(0x0fb589891e893c97), L64(0x28b414145014a044), L64(0xdfbae1e1a3e15b42),
    L64(0x2ca616165816b04e), L64(0x74f73a3ae83acdd2), L64(0xd2066969b9696fd0), L64(0x124109092409482d),
    L64(0xe0d77070dd70a7ad), L64(0x716fb6b6e2b6d954), L64(0xbd1ed0d067d0ceb7), L64(0xc7d6eded93ed3b7e),
    L64(0x85e2cccc17cc2edb), L64(0x8468424215422a57), L64(0x2d2c98985a98b4c2), L64(0x55eda4a4aaa4490e),
    L64(0x50752828a0285d88), L64(0xb8865c5c6d5cda31), L64(0xed6bf8f8c7f8933f), L64(0x11c28686228644a4),
};

static const php_hash_uint64 C3[256] = {
    L64(0x7830d818186018c0), L64(0xaf462623238c2305), L64(0xf991b8c6c63fc67e), L64(0x6fcdfbe8e887e813),
    L64(0xa113cb878726874c), L64(0x626d11b8b8dab8a9), L64(0x0502090101040108), L64(0x6e9e0d4f4f214f42),
    L64(0xee6c9b3636d836ad), L64(0x0451ffa6a6a2a659), L64(0xbdb90cd2d26fd2de), L64(0x06f70ef5f5f3f5fb),
    L64(0x80f2967979f979ef), L64(0xcede306f6fa16f5f), L64(0xef3f6d91917e91fc), L64(0x07a4f852525552aa),
    L64(0xfdc04760609d6027), L64(0x766535bcbccabc89), L64(0xcd2b379b9b569bac), L64(0x8c018a8e8e028e04),
    L64(0x155bd2a3a3b6a371), L64(0x3c186c0c0c300c60), L64(0x8af6847b7bf17bff), L64(0xe16a803535d435b5),
    L64(0x693af51d1d741de8), L64(0x47ddb3e0e0a7e053), L64(0xacb321d7d77bd7f6), L64(0xed999cc2c22fc25e),
    L64(0x965c432e2eb82e6d), L64(0x7a96294b4b314b62), L64(0x21e15dfefedffea3), L64(0x16aed55757415782),
    L64(0x412abd15155415a8), L64(0xb6eee87777c1779f), L64(0xeb6e923737dc37a5), L64(0x56d79ee5e5b3e57b),
    L64(0xd923139f9f469f8c), L64(0x17fd23f0f0e7f0d3), L64(0x7f94204a4a354a6a), L64(0x95a944dada4fda9e),
    L64(0x25b0a258587d58fa), L64(0xca8fcfc9c903c906), L64(0x8d527c2929a42955), L64(0x22145a0a0a280a50),
    L64(0x4f7f50b1b1feb1e1), L64(0x1a5dc9a0a0baa069), L64(0xdad6146b6bb16b7f), L64(0xab17d985852e855c),
    L64(0x73673cbdbdcebd81), L64(0x34ba8f5d5d695dd2), L64(0x5020901010401080), L64(0x03f507f4f4f7f4f3),
    L64(0xc08bddcbcb0bcb16), L64(0xc67cd33e3ef83eed), L64(0x110a2d0505140528), L64(0xe6ce78676781671f),
    L64(0x53d597e4e4b7e473), L64(0xbb4e0227279c2725), L64(0x5882734141194132), L64(0x9d0ba78b8b168b2c),
    L64(0x0153f6a7a7a6a751), L64(0x94fab27d7de97dcf), L64(0xfb374995956e95dc), L64(0x9fad56d8d847d88e),
    L64(0x30eb70fbfbcbfb8b), L64(0x71c1cdeeee9fee23), L64(0x91f8bb7c7ced7cc7), L64(0xe3cc716666856617),
    L64(0x8ea77bdddd53dda6), L64(0x4b2eaf17175c17b8), L64(0x468e454747014702), L64(0xdc211a9e9e429e84),
    L64(0xc589d4caca0fca1e), L64(0x995a582d2db42d75), L64(0x79632ebfbfc6bf91), L64(0x1b0e3f07071c0738),
    L64(0x2347acadad8ead01), L64(0x2fb4b05a5a755aea), L64(0xb51bef838336836c), L64(0xff66b63333cc3385),
    L64(0xf2c65c636391633f), L64(0x0a04120202080210), L64(0x384993aaaa92aa39), L64(0xa8e2de7171d971af),
    L64(0xcf8dc6c8c807c80e), L64(0x7d32d119196419c8), L64(0x70923b4949394972), L64(0x9aaf5fd9d943d986),
    L64(0x1df931f2f2eff2c3), L64(0x48dba8e3e3abe34b), L64(0x2ab6b95b5b715be2), L64(0x920dbc88881a8834),
    L64(0xc8293e9a9a529aa4), L64(0xbe4c0b262698262d), L64(0xfa64bf3232c8328d), L64(0x4a7d59b0b0fab0e9),
    L64(0x6acff2e9e983e91b), L64(0x331e770f0f3c0f78), L64(0xa6b733d5d573d5e6), L64(0xba1df480803a8074),
    L64(0x7c6127bebec2be99), L64(0xde87ebcdcd13cd26), L64(0xe468893434d034bd), L64(0x75903248483d487a),
    L64(0x24e354ffffdbffab), L64(0x8ff48d7a7af57af7), L64(0xea3d6490907a90f4), L64(0x3ebe9d5f5f615fc2),
    L64(0xa0403d202080201d), L64(0xd5d00f6868bd6867), L64(0x7234ca1a1a681ad0), L64(0x2c41b7aeae82ae19),
    L64(0x5e757db4b4eab4c9), L64(0x19a8ce54544d549a), L64(0xe53b7f93937693ec), L64(0xaa442f222288220d),
    L64(0xe9c86364648d6407), L64(0x12ff2af1f1e3f1db), L64(0xa2e6cc7373d173bf), L64(0x5a24821212481290),
    L64(0x5d807a40401d403a), L64(0x2810480808200840), L64(0xe89b95c3c32bc356), L64(0x7bc5dfecec97ec33),
    L64(0x90ab4ddbdb4bdb96), L64(0x1f5fc0a1a1bea161), L64(0x8307918d8d0e8d1c), L64(0xc97ac83d3df43df5),
    L64(0xf1335b97976697cc), L64(0x0000000000000000), L64(0xd483f9cfcf1bcf36), L64(0x87566e2b2bac2b45),
    L64(0xb3ece17676c57697), L64(0xb019e68282328264), L64(0xa9b128d6d67fd6fe), L64(0x7736c31b1b6c1bd8),
    L64(0x5b7774b5b5eeb5c1), L64(0x2943beafaf86af11), L64(0xdfd41d6a6ab56a77), L64(0x0da0ea50505d50ba),
    L64(0x4c8a574545094512), L64(0x18fb38f3f3ebf3cb), L64(0xf060ad3030c0309d), L64(0x74c3c4efef9bef2b),
    L64(0xc37eda3f3ffc3fe5), L64(0x1caac75555495592), L64(0x1059dba2a2b2a279), L64(0x65c9e9eaea8fea03),
    L64(0xecca6a656589650f), L64(0x686903babad2bab9), L64(0x935e4a2f2fbc2f65), L64(0xe79d8ec0c027c04e),
    L64(0x81a160dede5fdebe), L64(0x6c38fc1c1c701ce0), L64(0x2ee746fdfdd3fdbb), L64(0x649a1f4d4d294d52),
    L64(0xe0397692927292e4), L64(0xbceafa7575c9758f), L64(0x1e0c360606180630), L64(0x9809ae8a8a128a24),
    L64(0x40794bb2b2f2b2f9), L64(0x59d185e6e6bfe663), L64(0x361c7e0e0e380e70), L64(0x633ee71f1f7c1ff8),
    L64(0xf7c4556262956237), L64(0xa3b53ad4d477d4ee), L64(0x324d81a8a89aa829), L64(0xf4315296966296c4),
    L64(0x3aef62f9f9c3f99b), L64(0xf697a3c5c533c566), L64(0xb14a102525942535), L64(0x20b2ab59597959f2),
    L64(0xae15d084842a8454), L64(0xa7e4c57272d572b7), L64(0xdd72ec3939e439d5), L64(0x6198164c4c2d4c5a),
    L64(0x3bbc945e5e655eca), L64(0x85f09f7878fd78e7), L64(0xd870e53838e038dd), L64(0x8605988c8c0a8c14),
    L64(0xb2bf17d1d163d1c6), L64(0x0b57e4a5a5aea541), L64(0x4dd9a1e2e2afe243), L64(0xf8c24e616199612f),
    L64(0x457b42b3b3f6b3f1), L64(0xa542342121842115), L64(0xd625089c9c4a9c94), L64(0x663cee1e1e781ef0),
    L64(0x5286614343114322), L64(0xfc93b1c7c73bc776), L64(0x2be54ffcfcd7fcb3), L64(0x1408240404100420),
    L64(0x08a2e351515951b2), L64(0xc72f2599995e99bc), L64(0xc4da226d6da96d4f), L64(0x391a650d0d340d68),
    L64(0x35e979fafacffa83), L64(0x84a369dfdf5bdfb6), L64(0x9bfca97e7ee57ed7), L64(0xb44819242490243d),
    L64(0xd776fe3b3bec3bc5), L64(0x3d4b9aabab96ab31), L64(0xd181f0cece1fce3e), L64(0x5522991111441188),
    L64(0x8903838f8f068f0c), L64(0x6b9c044e4e254e4a), L64(0x517366b7b7e6b7d1), L64(0x60cbe0ebeb8beb0b),
    L64(0xcc78c13c3cf03cfd), L64(0xbf1ffd81813e817c), L64(0xfe354094946a94d4), L64(0x0cf31cf7f7fbf7eb),
    L64(0x676f18b9b9deb9a1), L64(0x5f268b13134c1398), L64(0x9c58512c2cb02c7d), L64(0xb8bb05d3d36bd3d6),
    L64(0x5cd38ce7e7bbe76b), L64(0xcbdc396e6ea56e57), L64(0xf395aac4c437c46e), L64(0x0f061b03030c0318),
    L64(0x13acdc565645568a), L64(0x49885e44440d441a), L64(0x9efea07f7fe17fdf), L64(0x374f88a9a99ea921),
    L64(0x8254672a2aa82a4d), L64(0x6d6b0abbbbd6bbb1), L64(0xe29f87c1c123c146), L64(0x02a6f153535153a2),
    L64(0x8ba572dcdc57dcae), L64(0x2716530b0b2c0b58), L64(0xd327019d9d4e9d9c), L64(0xc1d82b6c6cad6c47),
    L64(0xf562a43131c43195), L64(0xb9e8f37474cd7487), L64(0x09f115f6f6fff6e3), L64(0x438c4c464605460a),
    L64(0x2645a5acac8aac09), L64(0x970fb589891e893c), L64(0x4428b414145014a0), L64(0x42dfbae1e1a3e15b),
    L64(0x4e2ca616165816b0), L64(0xd274f73a3ae83acd), L64(0xd0d2066969b9696f), L64(0x2d12410909240948),
    L64(0xade0d77070dd70a7), L64(0x54716fb6b6e2b6d9), L64(0xb7bd1ed0d067d0ce), L64(0x7ec7d6eded93ed3b),
    L64(0xdb85e2cccc17cc2e), L64(0x578468424215422a), L64(0xc22d2c98985a98b4), L64(0x0e55eda4a4aaa449),
    L64(0x8850752828a0285d), L64(0x31b8865c5c6d5cda), L64(0x3fed6bf8f8c7f893), L64(0xa411c28686228644),
};

static const php_hash_uint64 C4[256] = {
    L64(0xc07830d818186018), L64(0x05af462623238c23), L64(0x7ef991b8c6c63fc6), L64(0x136fcdfbe8e887e8),
    L64(0x4ca113cb87872687), L64(0xa9626d11b8b8dab8), L64(0x0805020901010401), L64(0x426e9e0d4f4f214f),
    L64(0xadee6c9b3636d836), L64(0x590451ffa6a6a2a6), L64(0xdebdb90cd2d26fd2), L64(0xfb06f70ef5f5f3f5),
    L64(0xef80f2967979f979), L64(0x5fcede306f6fa16f), L64(0xfcef3f6d91917e91), L64(0xaa07a4f852525552),
    L64(0x27fdc04760609d60), L64(0x89766535bcbccabc), L64(0xaccd2b379b9b569b), L64(0x048c018a8e8e028e),
    L64(0x71155bd2a3a3b6a3), L64(0x603c186c0c0c300c), L64(0xff8af6847b7bf17b), L64(0xb5e16a803535d435),
    L64(0xe8693af51d1d741d), L64(0x5347ddb3e0e0a7e0), L64(0xf6acb321d7d77bd7), L64(0x5eed999cc2c22fc2),
    L64(0x6d965c432e2eb82e), L64(0x627a96294b4b314b), L64(0xa321e15dfefedffe), L64(0x8216aed557574157),
    L64(0xa8412abd15155415), L64(0x9fb6eee87777c177), L64(0xa5eb6e923737dc37), L64(0x7b56d79ee5e5b3e5),
    L64(0x8cd923139f9f469f), L64(0xd317fd23f0f0e7f0), L64(0x6a7f94204a4a354a), L64(0x9e95a944dada4fda),
    L64(0xfa25b0a258587d58), L64(0x06ca8fcfc9c903c9), L64(0x558d527c2929a429), L64(0x5022145a0a0a280a),
    L64(0xe14f7f50b1b1feb1), L64(0x691a5dc9a0a0baa0), L64(0x7fdad6146b6bb16b), L64(0x5cab17d985852e85),
    L64(0x8173673cbdbdcebd), L64(0xd234ba8f5d5d695d), L64(0x8050209010104010), L64(0xf303f507f4f4f7f4),
    L64(0x16c08bddcbcb0bcb), L64(0xedc67cd33e3ef83e), L64(0x28110a2d05051405), L64(0x1fe6ce7867678167),
    L64(0x7353d597e4e4b7e4), L64(0x25bb4e0227279c27), L64(0x3258827341411941), L64(0x2c9d0ba78b8b168b),
    L64(0x510153f6a7a7a6a7), L64(0xcf94fab27d7de97d), L64(0xdcfb374995956e95), L64(0x8e9fad56d8d847d8),
    L64(0x8b30eb70fbfbcbfb), L64(0x2371c1cdeeee9fee), L64(0xc791f8bb7c7ced7c), L64(0x17e3cc7166668566),
    L64(0xa68ea77bdddd53dd), L64(0xb84b2eaf17175c17), L64(0x02468e4547470147), L64(0x84dc211a9e9e429e),
    L64(0x1ec589d4caca0fca), L64(0x75995a582d2db42d), L64(0x9179632ebfbfc6bf), L64(0x381b0e3f07071c07),
    L64(0x012347acadad8ead), L64(0xea2fb4b05a5a755a), L64(0x6cb51bef83833683), L64(0x85ff66b63333cc33),
    L64(0x3ff2c65c63639163), L64(0x100a041202020802), L64(0x39384993aaaa92aa), L64(0xafa8e2de7171d971),
    L64(0x0ecf8dc6c8c807c8), L64(0xc87d32d119196419), L64(0x7270923b49493949), L64(0x869aaf5fd9d943d9),
    L64(0xc31df931f2f2eff2), L64(0x4b48dba8e3e3abe3), L64(0xe22ab6b95b5b715b), L64(0x34920dbc88881a88),
    L64(0xa4c8293e9a9a529a), L64(0x2dbe4c0b26269826), L64(0x8dfa64bf3232c832), L64(0xe94a7d59b0b0fab0),
    L64(0x1b6acff2e9e983e9), L64(0x78331e770f0f3c0f), L64(0xe6a6b733d5d573d5), L64(0x74ba1df480803a80),
    L64(0x997c6127bebec2be), L64(0x26de87ebcdcd13cd), L64(0xbde468893434d034), L64(0x7a75903248483d48),
    L64(0xab24e354ffffdbff), L64(0xf78ff48d7a7af57a), L64(0xf4ea3d6490907a90), L64(0xc23ebe9d5f5f615f),
    L64(0x1da0403d20208020), L64(0x67d5d00f6868bd68), L64(0xd07234ca1a1a681a), L64(0x192c41b7aeae82ae),
    L64(0xc95e757db4b4eab4), L64(0x9a19a8ce54544d54), L64(0xece53b7f93937693), L64(0x0daa442f22228822),
    L64(0x07e9c86364648d64), L64(0xdb12ff2af1f1e3f1), L64(0xbfa2e6cc7373d173), L64(0x905a248212124812),
    L64(0x3a5d807a40401d40), L64(0x4028104808082008), L64(0x56e89b95c3c32bc3), L64(0x337bc5dfecec97ec),
    L64(0x9690ab4ddbdb4bdb), L64(0x611f5fc0a1a1bea1), L64(0x1c8307918d8d0e8d), L64(0xf5c97ac83d3df43d),
    L64(0xccf1335b97976697), L64(0x0000000000000000), L64(0x36d483f9cfcf1bcf), L64(0x4587566e2b2bac2b),
    L64(0x97b3ece17676c576), L64(0x64b019e682823282), L64(0xfea9b128d6d67fd6), L64(0xd87736c31b1b6c1b),
    L64(0xc15b7774b5b5eeb5), L64(0x112943beafaf86af), L64(0x77dfd41d6a6ab56a), L64(0xba0da0ea50505d50),
    L64(0x124c8a5745450945), L64(0xcb18fb38f3f3ebf3), L64(0x9df060ad3030c030), L64(0x2b74c3c4efef9bef),
    L64(0xe5c37eda3f3ffc3f), L64(0x921caac755554955), L64(0x791059dba2a2b2a2), L64(0x0365c9e9eaea8fea),
    L64(0x0fecca6a65658965), L64(0xb9686903babad2ba), L64(0x65935e4a2f2fbc2f), L64(0x4ee79d8ec0c027c0),
    L64(0xbe81a160dede5fde), L64(0xe06c38fc1c1c701c), L64(0xbb2ee746fdfdd3fd), L64(0x52649a1f4d4d294d),
    L64(0xe4e0397692927292), L64(0x8fbceafa7575c975), L64(0x301e0c3606061806), L64(0x249809ae8a8a128a),
    L64(0xf940794bb2b2f2b2), L64(0x6359d185e6e6bfe6), L64(0x70361c7e0e0e380e), L64(0xf8633ee71f1f7c1f),
    L64(0x37f7c45562629562), L64(0xeea3b53ad4d477d4), L64(0x29324d81a8a89aa8), L64(0xc4f4315296966296),
    L64(0x9b3aef62f9f9c3f9), L64(0x66f697a3c5c533c5), L64(0x35b14a1025259425), L64(0xf220b2ab59597959),
    L64(0x54ae15d084842a84), L64(0xb7a7e4c57272d572), L64(0xd5dd72ec3939e439), L64(0x5a6198164c4c2d4c),
    L64(0xca3bbc945e5e655e), L64(0xe785f09f7878fd78), L64(0xddd870e53838e038), L64(0x148605988c8c0a8c),
    L64(0xc6b2bf17d1d163d1), L64(0x410b57e4a5a5aea5), L64(0x434dd9a1e2e2afe2), L64(0x2ff8c24e61619961),
    L64(0xf1457b42b3b3f6b3), L64(0x15a5423421218421), L64(0x94d625089c9c4a9c), L64(0xf0663cee1e1e781e),
    L64(0x2252866143431143), L64(0x76fc93b1c7c73bc7), L64(0xb32be54ffcfcd7fc), L64(0x2014082404041004),
    L64(0xb208a2e351515951), L64(0xbcc72f2599995e99), L64(0x4fc4da226d6da96d), L64(0x68391a650d0d340d),
    L64(0x8335e979fafacffa), L64(0xb684a369dfdf5bdf), L64(0xd79bfca97e7ee57e), L64(0x3db4481924249024),
    L64(0xc5d776fe3b3bec3b), L64(0x313d4b9aabab96ab), L64(0x3ed181f0cece1fce), L64(0x8855229911114411),
    L64(0x0c8903838f8f068f), L64(0x4a6b9c044e4e254e), L64(0xd1517366b7b7e6b7), L64(0x0b60cbe0ebeb8beb),
    L64(0xfdcc78c13c3cf03c), L64(0x7cbf1ffd81813e81), L64(0xd4fe354094946a94), L64(0xeb0cf31cf7f7fbf7),
    L64(0xa1676f18b9b9deb9), L64(0x985f268b13134c13), L64(0x7d9c58512c2cb02c), L64(0xd6b8bb05d3d36bd3),
    L64(0x6b5cd38ce7e7bbe7), L64(0x57cbdc396e6ea56e), L64(0x6ef395aac4c437c4), L64(0x180f061b03030c03),
    L64(0x8a13acdc56564556), L64(0x1a49885e44440d44), L64(0xdf9efea07f7fe17f), L64(0x21374f88a9a99ea9),
    L64(0x4d8254672a2aa82a), L64(0xb16d6b0abbbbd6bb), L64(0x46e29f87c1c123c1), L64(0xa202a6f153535153),
    L64(0xae8ba572dcdc57dc), L64(0x582716530b0b2c0b), L64(0x9cd327019d9d4e9d), L64(0x47c1d82b6c6cad6c),
    L64(0x95f562a43131c431), L64(0x87b9e8f37474cd74), L64(0xe309f115f6f6fff6), L64(0x0a438c4c46460546),
    L64(0x092645a5acac8aac), L64(0x3c970fb589891e89), L64(0xa04428b414145014), L64(0x5b42dfbae1e1a3e1),
    L64(0xb04e2ca616165816), L64(0xcdd274f73a3ae83a), L64(0x6fd0d2066969b969), L64(0x482d124109092409),
    L64(0xa7ade0d77070dd70), L64(0xd954716fb6b6e2b6), L64(0xceb7bd1ed0d067d0), L64(0x3b7ec7d6eded93ed),
    L64(0x2edb85e2cccc17cc), L64(0x2a57846842421542), L64(0xb4c22d2c98985a98), L64(0x490e55eda4a4aaa4),
    L64(0x5d8850752828a028), L64(0xda31b8865c5c6d5c), L64(0x933fed6bf8f8c7f8), L64(0x44a411c286862286),
};

static const php_hash_uint64 C5[256] = {
    L64(0x18c07830d8181860), L64(0x2305af462623238c), L64(0xc67ef991b8c6c63f), L64(0xe8136fcdfbe8e887),
    L64(0x874ca113cb878726), L64(0xb8a9626d11b8b8da), L64(0x0108050209010104), L64(0x4f426e9e0d4f4f21),
    L64(0x36adee6c9b3636d8), L64(0xa6590451ffa6a6a2), L64(0xd2debdb90cd2d26f), L64(0xf5fb06f70ef5f5f3),
    L64(0x79ef80f2967979f9), L64(0x6f5fcede306f6fa1), L64(0x91fcef3f6d91917e), L64(0x52aa07a4f8525255),
    L64(0x6027fdc04760609d), L64(0xbc89766535bcbcca), L64(0x9baccd2b379b9b56), L64(0x8e048c018a8e8e02),
    L64(0xa371155bd2a3a3b6), L64(0x0c603c186c0c0c30), L64(0x7bff8af6847b7bf1), L64(0x35b5e16a803535d4),
    L64(0x1de8693af51d1d74), L64(0xe05347ddb3e0e0a7), L64(0xd7f6acb321d7d77b), L64(0xc25eed999cc2c22f),
    L64(0x2e6d965c432e2eb8), L64(0x4b627a96294b4b31), L64(0xfea321e15dfefedf), L64(0x578216aed5575741),
    L64(0x15a8412abd151554), L64(0x779fb6eee87777c1), L64(0x37a5eb6e923737dc), L64(0xe57b56d79ee5e5b3),
    L64(0x9f8cd923139f9f46), L64(0xf0d317fd23f0f0e7), L64(0x4a6a7f94204a4a35), L64(0xda9e95a944dada4f),
    L64(0x58fa25b0a258587d), L64(0xc906ca8fcfc9c903), L64(0x29558d527c2929a4), L64(0x0a5022145a0a0a28),
    L64(0xb1e14f7f50b1b1fe), L64(0xa0691a5dc9a0a0ba), L64(0x6b7fdad6146b6bb1), L64(0x855cab17d985852e),
    L64(0xbd8173673cbdbdce), L64(0x5dd234ba8f5d5d69), L64(0x1080502090101040), L64(0xf4f303f507f4f4f7),
    L64(0xcb16c08bddcbcb0b), L64(0x3eedc67cd33e3ef8), L64(0x0528110a2d050514), L64(0x671fe6ce78676781),
    L64(0xe47353d597e4e4b7), L64(0x2725bb4e0227279c), L64(0x4132588273414119), L64(0x8b2c9d0ba78b8b16),
    L64(0xa7510153f6a7a7a6), L64(0x7dcf94fab27d7de9), L64(0x95dcfb374995956e), L64(0xd88e9fad56d8d847),
    L64(0xfb8b30eb70fbfbcb), L64(0xee2371c1cdeeee9f), L64(0x7cc791f8bb7c7ced), L64(0x6617e3cc71666685),
    L64(0xdda68ea77bdddd53), L64(0x17b84b2eaf17175c), L64(0x4702468e45474701), L64(0x9e84dc211a9e9e42),
    L64(0xca1ec589d4caca0f), L64(0x2d75995a582d2db4), L64(0xbf9179632ebfbfc6), L64(0x07381b0e3f07071c),
    L64(0xad012347acadad8e), L64(0x5aea2fb4b05a5a75), L64(0x836cb51bef838336), L64(0x3385ff66b63333cc),
    L64(0x633ff2c65c636391), L64(0x02100a0412020208), L64(0xaa39384993aaaa92), L64(0x71afa8e2de7171d9),
    L64(0xc80ecf8dc6c8c807), L64(0x19c87d32d1191964), L64(0x497270923b494939), L64(0xd9869aaf5fd9d943),
    L64(0xf2c31df931f2f2ef), L64(0xe34b48dba8e3e3ab), L64(0x5be22ab6b95b5b71), L64(0x8834920dbc88881a),
    L64(0x9aa4c8293e9a9a52), L64(0x262dbe4c0b262698), L64(0x328dfa64bf3232c8), L64(0xb0e94a7d59b0b0fa),
    L64(0xe91b6acff2e9e983), L64(0x0f78331e770f0f3c), L64(0xd5e6a6b733d5d573), L64(0x8074ba1df480803a),
    L64(0xbe997c6127bebec2), L64(0xcd26de87ebcdcd13), L64(0x34bde468893434d0), L64(0x487a75903248483d),
    L64(0xffab24e354ffffdb), L64(0x7af78ff48d7a7af5), L64(0x90f4ea3d6490907a), L64(0x5fc23ebe9d5f5f61),
    L64(0x201da0403d202080), L64(0x6867d5d00f6868bd), L64(0x1ad07234ca1a1a68), L64(0xae192c41b7aeae82),
    L64(0xb4c95e757db4b4ea), L64(0x549a19a8ce54544d), L64(0x93ece53b7f939376), L64(0x220daa442f222288),
    L64(0x6407e9c86364648d), L64(0xf1db12ff2af1f1e3), L64(0x73bfa2e6cc7373d1), L64(0x12905a2482121248),
    L64(0x403a5d807a40401d), L64(0x0840281048080820), L64(0xc356e89b95c3c32b), L64(0xec337bc5dfecec97),
    L64(0xdb9690ab4ddbdb4b), L64(0xa1611f5fc0a1a1be), L64(0x8d1c8307918d8d0e), L64(0x3df5c97ac83d3df4),
    L64(0x97ccf1335b979766), L64(0x0000000000000000), L64(0xcf36d483f9cfcf1b), L64(0x2b4587566e2b2bac),
    L64(0x7697b3ece17676c5), L64(0x8264b019e6828232), L64(0xd6fea9b128d6d67f), L64(0x1bd87736c31b1b6c),
    L64(0xb5c15b7774b5b5ee), L64(0xaf112943beafaf86), L64(0x6a77dfd41d6a6ab5), L64(0x50ba0da0ea50505d),
    L64(0x45124c8a57454509), L64(0xf3cb18fb38f3f3eb), L64(0x309df060ad3030c0), L64(0xef2b74c3c4efef9b),
    L64(0x3fe5c37eda3f3ffc), L64(0x55921caac7555549), L64(0xa2791059dba2a2b2), L64(0xea0365c9e9eaea8f),
    L64(0x650fecca6a656589), L64(0xbab9686903babad2), L64(0x2f65935e4a2f2fbc), L64(0xc04ee79d8ec0c027),
    L64(0xdebe81a160dede5f), L64(0x1ce06c38fc1c1c70), L64(0xfdbb2ee746fdfdd3), L64(0x4d52649a1f4d4d29),
    L64(0x92e4e03976929272), L64(0x758fbceafa7575c9), L64(0x06301e0c36060618), L64(0x8a249809ae8a8a12),
    L64(0xb2f940794bb2b2f2), L64(0xe66359d185e6e6bf), L64(0x0e70361c7e0e0e38), L64(0x1ff8633ee71f1f7c),
    L64(0x6237f7c455626295), L64(0xd4eea3b53ad4d477), L64(0xa829324d81a8a89a), L64(0x96c4f43152969662),
    L64(0xf99b3aef62f9f9c3), L64(0xc566f697a3c5c533), L64(0x2535b14a10252594), L64(0x59f220b2ab595979),
    L64(0x8454ae15d084842a), L64(0x72b7a7e4c57272d5), L64(0x39d5dd72ec3939e4), L64(0x4c5a6198164c4c2d),
    L64(0x5eca3bbc945e5e65), L64(0x78e785f09f7878fd), L64(0x38ddd870e53838e0), L64(0x8c148605988c8c0a),
    L64(0xd1c6b2bf17d1d163), L64(0xa5410b57e4a5a5ae), L64(0xe2434dd9a1e2e2af), L64(0x612ff8c24e616199),
    L64(0xb3f1457b42b3b3f6), L64(0x2115a54234212184), L64(0x9c94d625089c9c4a), L64(0x1ef0663cee1e1e78),
    L64(0x4322528661434311), L64(0xc776fc93b1c7c73b), L64(0xfcb32be54ffcfcd7), L64(0x0420140824040410),
    L64(0x51b208a2e3515159), L64(0x99bcc72f2599995e), L64(0x6d4fc4da226d6da9), L64(0x0d68391a650d0d34),
    L64(0xfa8335e979fafacf), L64(0xdfb684a369dfdf5b), L64(0x7ed79bfca97e7ee5), L64(0x243db44819242490),
    L64(0x3bc5d776fe3b3bec), L64(0xab313d4b9aabab96), L64(0xce3ed181f0cece1f), L64(0x1188552299111144),
    L64(0x8f0c8903838f8f06), L64(0x4e4a6b9c044e4e25), L64(0xb7d1517366b7b7e6), L64(0xeb0b60cbe0ebeb8b),
    L64(0x3cfdcc78c13c3cf0), L64(0x817cbf1ffd81813e), L64(0x94d4fe354094946a), L64(0xf7eb0cf31cf7f7fb),
    L64(0xb9a1676f18b9b9de), L64(0x13985f268b13134c), L64(0x2c7d9c58512c2cb0), L64(0xd3d6b8bb05d3d36b),
    L64(0xe76b5cd38ce7e7bb), L64(0x6e57cbdc396e6ea5), L64(0xc46ef395aac4c437), L64(0x03180f061b03030c),
    L64(0x568a13acdc565645), L64(0x441a49885e44440d), L64(0x7fdf9efea07f7fe1), L64(0xa921374f88a9a99e),
    L64(0x2a4d8254672a2aa8), L64(0xbbb16d6b0abbbbd6), L64(0xc146e29f87c1c123), L64(0x53a202a6f1535351),
    L64(0xdcae8ba572dcdc57), L64(0x0b582716530b0b2c), L64(0x9d9cd327019d9d4e), L64(0x6c47c1d82b6c6cad),
    L64(0x3195f562a43131c4), L64(0x7487b9e8f37474cd), L64(0xf6e309f115f6f6ff), L64(0x460a438c4c464605),
    L64(0xac092645a5acac8a), L64(0x893c970fb589891e), L64(0x14a04428b4141450), L64(0xe15b42dfbae1e1a3),
    L64(0x16b04e2ca6161658), L64(0x3acdd274f73a3ae8), L64(0x696fd0d2066969b9), L64(0x09482d1241090924),
    L64(0x70a7ade0d77070dd), L64(0xb6d954716fb6b6e2), L64(0xd0ceb7bd1ed0d067), L64(0xed3b7ec7d6eded93),
    L64(0xcc2edb85e2cccc17), L64(0x422a578468424215), L64(0x98b4c22d2c98985a), L64(0xa4490e55eda4a4aa),
    L64(0x285d8850752828a0), L64(0x5cda31b8865c5c6d), L64(0xf8933fed6bf8f8c7), L64(0x8644a411c2868622),
};

static const php_hash_uint64 C6[256] = {
    L64(0x6018c07830d81818), L64(0x8c2305af46262323), L64(0x3fc67ef991b8c6c6), L64(0x87e8136fcdfbe8e8),
    L64(0x26874ca113cb8787), L64(0xdab8a9626d11b8b8), L64(0x0401080502090101), L64(0x214f426e9e0d4f4f),
    L64(0xd836adee6c9b3636), L64(0xa2a6590451ffa6a6), L64(0x6fd2debdb90cd2d2), L64(0xf3f5fb06f70ef5f5),
    L64(0xf979ef80f2967979), L64(0xa16f5fcede306f6f), L64(0x7e91fcef3f6d9191), L64(0x5552aa07a4f85252),
    L64(0x9d6027fdc0476060), L64(0xcabc89766535bcbc), L64(0x569baccd2b379b9b), L64(0x028e048c018a8e8e),
    L64(0xb6a371155bd2a3a3), L64(0x300c603c186c0c0c), L64(0xf17bff8af6847b7b), L64(0xd435b5e16a803535),
    L64(0x741de8693af51d1d), L64(0xa7e05347ddb3e0e0), L64(0x7bd7f6acb321d7d7), L64(0x2fc25eed999cc2c2),
    L64(0xb82e6d965c432e2e), L64(0x314b627a96294b4b), L64(0xdffea321e15dfefe), L64(0x41578216aed55757),
    L64(0x5415a8412abd1515), L64(0xc1779fb6eee87777), L64(0xdc37a5eb6e923737), L64(0xb3e57b56d79ee5e5),
    L64(0x469f8cd923139f9f), L64(0xe7f0d317fd23f0f0), L64(0x354a6a7f94204a4a), L64(0x4fda9e95a944dada),
    L64(0x7d58fa25b0a25858), L64(0x03c906ca8fcfc9c9), L64(0xa429558d527c2929), L64(0x280a5022145a0a0a),
    L64(0xfeb1e14f7f50b1b1), L64(0xbaa0691a5dc9a0a0), L64(0xb16b7fdad6146b6b), L64(0x2e855cab17d98585),
    L64(0xcebd8173673cbdbd), L64(0x695dd234ba8f5d5d), L64(0x4010805020901010), L64(0xf7f4f303f507f4f4),
    L64(0x0bcb16c08bddcbcb), L64(0xf83eedc67cd33e3e), L64(0x140528110a2d0505), L64(0x81671fe6ce786767),
    L64(0xb7e47353d597e4e4), L64(0x9c2725bb4e022727), L64(0x1941325882734141), L64(0x168b2c9d0ba78b8b),
    L64(0xa6a7510153f6a7a7), L64(0xe97dcf94fab27d7d), L64(0x6e95dcfb37499595), L64(0x47d88e9fad56d8d8),
    L64(0xcbfb8b30eb70fbfb), L64(0x9fee2371c1cdeeee), L64(0xed7cc791f8bb7c7c), L64(0x856617e3cc716666),
    L64(0x53dda68ea77bdddd), L64(0x5c17b84b2eaf1717), L64(0x014702468e454747), L64(0x429e84dc211a9e9e),
    L64(0x0fca1ec589d4caca), L64(0xb42d75995a582d2d), L64(0xc6bf9179632ebfbf), L64(0x1c07381b0e3f0707),
    L64(0x8ead012347acadad), L64(0x755aea2fb4b05a5a), L64(0x36836cb51bef8383), L64(0xcc3385ff66b63333),
    L64(0x91633ff2c65c6363), L64(0x0802100a04120202), L64(0x92aa39384993aaaa), L64(0xd971afa8e2de7171),
    L64(0x07c80ecf8dc6c8c8), L64(0x6419c87d32d11919), L64(0x39497270923b4949), L64(0x43d9869aaf5fd9d9),
    L64(0xeff2c31df931f2f2), L64(0xabe34b48dba8e3e3), L64(0x715be22ab6b95b5b), L64(0x1a8834920dbc8888),
    L64(0x529aa4c8293e9a9a), L64(0x98262dbe4c0b2626), L64(0xc8328dfa64bf3232), L64(0xfab0e94a7d59b0b0),
    L64(0x83e91b6acff2e9e9), L64(0x3c0f78331e770f0f), L64(0x73d5e6a6b733d5d5), L64(0x3a8074ba1df48080),
    L64(0xc2be997c6127bebe), L64(0x13cd26de87ebcdcd), L64(0xd034bde468893434), L64(0x3d487a7590324848),
    L64(0xdbffab24e354ffff), L64(0xf57af78ff48d7a7a), L64(0x7a90f4ea3d649090), L64(0x615fc23ebe9d5f5f),
    L64(0x80201da0403d2020), L64(0xbd6867d5d00f6868), L64(0x681ad07234ca1a1a), L64(0x82ae192c41b7aeae),
    L64(0xeab4c95e757db4b4), L64(0x4d549a19a8ce5454), L64(0x7693ece53b7f9393), L64(0x88220daa442f2222),
    L64(0x8d6407e9c8636464), L64(0xe3f1db12ff2af1f1), L64(0xd173bfa2e6cc7373), L64(0x4812905a24821212),
    L64(0x1d403a5d807a4040), L64(0x2008402810480808), L64(0x2bc356e89b95c3c3), L64(0x97ec337bc5dfecec),
    L64(0x4bdb9690ab4ddbdb), L64(0xbea1611f5fc0a1a1), L64(0x0e8d1c8307918d8d), L64(0xf43df5c97ac83d3d),
    L64(0x6697ccf1335b9797), L64(0x0000000000000000), L64(0x1bcf36d483f9cfcf), L64(0xac2b4587566e2b2b),
    L64(0xc57697b3ece17676), L64(0x328264b019e68282), L64(0x7fd6fea9b128d6d6), L64(0x6c1bd87736c31b1b),
    L64(0xeeb5c15b7774b5b5), L64(0x86af112943beafaf), L64(0xb56a77dfd41d6a6a), L64(0x5d50ba0da0ea5050),
    L64(0x0945124c8a574545), L64(0xebf3cb18fb38f3f3), L64(0xc0309df060ad3030), L64(0x9bef2b74c3c4efef),
    L64(0xfc3fe5c37eda3f3f), L64(0x4955921caac75555), L64(0xb2a2791059dba2a2), L64(0x8fea0365c9e9eaea),
    L64(0x89650fecca6a6565), L64(0xd2bab9686903baba), L64(0xbc2f65935e4a2f2f), L64(0x27c04ee79d8ec0c0),
    L64(0x5fdebe81a160dede), L64(0x701ce06c38fc1c1c), L64(0xd3fdbb2ee746fdfd), L64(0x294d52649a1f4d4d),
    L64(0x7292e4e039769292), L64(0xc9758fbceafa7575), L64(0x1806301e0c360606), L64(0x128a249809ae8a8a),
    L64(0xf2b2f940794bb2b2), L64(0xbfe66359d185e6e6), L64(0x380e70361c7e0e0e), L64(0x7c1ff8633ee71f1f),
    L64(0x956237f7c4556262), L64(0x77d4eea3b53ad4d4), L64(0x9aa829324d81a8a8), L64(0x6296c4f431529696),
    L64(0xc3f99b3aef62f9f9), L64(0x33c566f697a3c5c5), L64(0x942535b14a102525), L64(0x7959f220b2ab5959),
    L64(0x2a8454ae15d08484), L64(0xd572b7a7e4c57272), L64(0xe439d5dd72ec3939), L64(0x2d4c5a6198164c4c),
    L64(0x655eca3bbc945e5e), L64(0xfd78e785f09f7878), L64(0xe038ddd870e53838), L64(0x0a8c148605988c8c),
    L64(0x63d1c6b2bf17d1d1), L64(0xaea5410b57e4a5a5), L64(0xafe2434dd9a1e2e2), L64(0x99612ff8c24e6161),
    L64(0xf6b3f1457b42b3b3), L64(0x842115a542342121), L64(0x4a9c94d625089c9c), L64(0x781ef0663cee1e1e),
    L64(0x1143225286614343), L64(0x3bc776fc93b1c7c7), L64(0xd7fcb32be54ffcfc), L64(0x1004201408240404),
    L64(0x5951b208a2e35151), L64(0x5e99bcc72f259999), L64(0xa96d4fc4da226d6d), L64(0x340d68391a650d0d),
    L64(0xcffa8335e979fafa), L64(0x5bdfb684a369dfdf), L64(0xe57ed79bfca97e7e), L64(0x90243db448192424),
    L64(0xec3bc5d776fe3b3b), L64(0x96ab313d4b9aabab), L64(0x1fce3ed181f0cece), L64(0x4411885522991111),
    L64(0x068f0c8903838f8f), L64(0x254e4a6b9c044e4e), L64(0xe6b7d1517366b7b7), L64(0x8beb0b60cbe0ebeb),
    L64(0xf03cfdcc78c13c3c), L64(0x3e817cbf1ffd8181), L64(0x6a94d4fe35409494), L64(0xfbf7eb0cf31cf7f7),
    L64(0xdeb9a1676f18b9b9), L64(0x4c13985f268b1313), L64(0xb02c7d9c58512c2c), L64(0x6bd3d6b8bb05d3d3),
    L64(0xbbe76b5cd38ce7e7), L64(0xa56e57cbdc396e6e), L64(0x37c46ef395aac4c4), L64(0x0c03180f061b0303),
    L64(0x45568a13acdc5656), L64(0x0d441a49885e4444), L64(0xe17fdf9efea07f7f), L64(0x9ea921374f88a9a9),
    L64(0xa82a4d8254672a2a), L64(0xd6bbb16d6b0abbbb), L64(0x23c146e29f87c1c1), L64(0x5153a202a6f15353),
    L64(0x57dcae8ba572dcdc), L64(0x2c0b582716530b0b), L64(0x4e9d9cd327019d9d), L64(0xad6c47c1d82b6c6c),
    L64(0xc43195f562a43131), L64(0xcd7487b9e8f37474), L64(0xfff6e309f115f6f6), L64(0x05460a438c4c4646),
    L64(0x8aac092645a5acac), L64(0x1e893c970fb58989), L64(0x5014a04428b41414), L64(0xa3e15b42dfbae1e1),
    L64(0x5816b04e2ca61616), L64(0xe83acdd274f73a3a), L64(0xb9696fd0d2066969), L64(0x2409482d12410909),
    L64(0xdd70a7ade0d77070), L64(0xe2b6d954716fb6b6), L64(0x67d0ceb7bd1ed0d0), L64(0x93ed3b7ec7d6eded),
    L64(0x17cc2edb85e2cccc), L64(0x15422a5784684242), L64(0x5a98b4c22d2c9898), L64(0xaaa4490e55eda4a4),
    L64(0xa0285d8850752828), L64(0x6d5cda31b8865c5c), L64(0xc7f8933fed6bf8f8), L64(0x228644a411c28686),
};

static const php_hash_uint64 C7[256] = {
    L64(0x186018c07830d818), L64(0x238c2305af462623), L64(0xc63fc67ef991b8c6), L64(0xe887e8136fcdfbe8),
    L64(0x8726874ca113cb87), L64(0xb8dab8a9626d11b8), L64(0x0104010805020901), L64(0x4f214f426e9e0d4f),
    L64(0x36d836adee6c9b36), L64(0xa6a2a6590451ffa6), L64(0xd26fd2debdb90cd2), L64(0xf5f3f5fb06f70ef5),
    L64(0x79f979ef80f29679), L64(0x6fa16f5fcede306f), L64(0x917e91fcef3f6d91), L64(0x525552aa07a4f852),
    L64(0x609d6027fdc04760), L64(0xbccabc89766535bc), L64(0x9b569baccd2b379b), L64(0x8e028e048c018a8e),
    L64(0xa3b6a371155bd2a3), L64(0x0c300c603c186c0c), L64(0x7bf17bff8af6847b), L64(0x35d435b5e16a8035),
    L64(0x1d741de8693af51d), L64(0xe0a7e05347ddb3e0), L64(0xd77bd7f6acb321d7), L64(0xc22fc25eed999cc2),
    L64(0x2eb82e6d965c432e), L64(0x4b314b627a96294b), L64(0xfedffea321e15dfe), L64(0x5741578216aed557),
    L64(0x155415a8412abd15), L64(0x77c1779fb6eee877), L64(0x37dc37a5eb6e9237), L64(0xe5b3e57b56d79ee5),
    L64(0x9f469f8cd923139f), L64(0xf0e7f0d317fd23f0), L64(0x4a354a6a7f94204a), L64(0xda4fda9e95a944da),
    L64(0x587d58fa25b0a258), L64(0xc903c906ca8fcfc9), L64(0x29a429558d527c29), L64(0x0a280a5022145a0a),
    L64(0xb1feb1e14f7f50b1), L64(0xa0baa0691a5dc9a0), L64(0x6bb16b7fdad6146b), L64(0x852e855cab17d985),
    L64(0xbdcebd8173673cbd), L64(0x5d695dd234ba8f5d), L64(0x1040108050209010), L64(0xf4f7f4f303f507f4),
    L64(0xcb0bcb16c08bddcb), L64(0x3ef83eedc67cd33e), L64(0x05140528110a2d05), L64(0x6781671fe6ce7867),
    L64(0xe4b7e47353d597e4), L64(0x279c2725bb4e0227), L64(0x4119413258827341), L64(0x8b168b2c9d0ba78b),
    L64(0xa7a6a7510153f6a7), L64(0x7de97dcf94fab27d), L64(0x956e95dcfb374995), L64(0xd847d88e9fad56d8),
    L64(0xfbcbfb8b30eb70fb), L64(0xee9fee2371c1cdee), L64(0x7ced7cc791f8bb7c), L64(0x66856617e3cc7166),
    L64(0xdd53dda68ea77bdd), L64(0x175c17b84b2eaf17), L64(0x47014702468e4547), L64(0x9e429e84dc211a9e),
    L64(0xca0fca1ec589d4ca), L64(0x2db42d75995a582d), L64(0xbfc6bf9179632ebf), L64(0x071c07381b0e3f07),
    L64(0xad8ead012347acad), L64(0x5a755aea2fb4b05a), L64(0x8336836cb51bef83), L64(0x33cc3385ff66b633),
    L64(0x6391633ff2c65c63), L64(0x020802100a041202), L64(0xaa92aa39384993aa), L64(0x71d971afa8e2de71),
    L64(0xc807c80ecf8dc6c8), L64(0x196419c87d32d119), L64(0x4939497270923b49), L64(0xd943d9869aaf5fd9),
    L64(0xf2eff2c31df931f2), L64(0xe3abe34b48dba8e3), L64(0x5b715be22ab6b95b), L64(0x881a8834920dbc88),
    L64(0x9a529aa4c8293e9a), L64(0x2698262dbe4c0b26), L64(0x32c8328dfa64bf32), L64(0xb0fab0e94a7d59b0),
    L64(0xe983e91b6acff2e9), L64(0x0f3c0f78331e770f), L64(0xd573d5e6a6b733d5), L64(0x803a8074ba1df480),
    L64(0xbec2be997c6127be), L64(0xcd13cd26de87ebcd), L64(0x34d034bde4688934), L64(0x483d487a75903248),
    L64(0xffdbffab24e354ff), L64(0x7af57af78ff48d7a), L64(0x907a90f4ea3d6490), L64(0x5f615fc23ebe9d5f),
    L64(0x2080201da0403d20), L64(0x68bd6867d5d00f68), L64(0x1a681ad07234ca1a), L64(0xae82ae192c41b7ae),
    L64(0xb4eab4c95e757db4), L64(0x544d549a19a8ce54), L64(0x937693ece53b7f93), L64(0x2288220daa442f22),
    L64(0x648d6407e9c86364), L64(0xf1e3f1db12ff2af1), L64(0x73d173bfa2e6cc73), L64(0x124812905a248212),
    L64(0x401d403a5d807a40), L64(0x0820084028104808), L64(0xc32bc356e89b95c3), L64(0xec97ec337bc5dfec),
    L64(0xdb4bdb9690ab4ddb), L64(0xa1bea1611f5fc0a1), L64(0x8d0e8d1c8307918d), L64(0x3df43df5c97ac83d),
    L64(0x976697ccf1335b97), L64(0x0000000000000000), L64(0xcf1bcf36d483f9cf), L64(0x2bac2b4587566e2b),
    L64(0x76c57697b3ece176), L64(0x82328264b019e682), L64(0xd67fd6fea9b128d6), L64(0x1b6c1bd87736c31b),
    L64(0xb5eeb5c15b7774b5), L64(0xaf86af112943beaf), L64(0x6ab56a77dfd41d6a), L64(0x505d50ba0da0ea50),
    L64(0x450945124c8a5745), L64(0xf3ebf3cb18fb38f3), L64(0x30c0309df060ad30), L64(0xef9bef2b74c3c4ef),
    L64(0x3ffc3fe5c37eda3f), L64(0x554955921caac755), L64(0xa2b2a2791059dba2), L64(0xea8fea0365c9e9ea),
    L64(0x6589650fecca6a65), L64(0xbad2bab9686903ba), L64(0x2fbc2f65935e4a2f), L64(0xc027c04ee79d8ec0),
    L64(0xde5fdebe81a160de), L64(0x1c701ce06c38fc1c), L64(0xfdd3fdbb2ee746fd), L64(0x4d294d52649a1f4d),
    L64(0x927292e4e0397692), L64(0x75c9758fbceafa75), L64(0x061806301e0c3606), L64(0x8a128a249809ae8a),
    L64(0xb2f2b2f940794bb2), L64(0xe6bfe66359d185e6), L64(0x0e380e70361c7e0e), L64(0x1f7c1ff8633ee71f),
    L64(0x62956237f7c45562), L64(0xd477d4eea3b53ad4), L64(0xa89aa829324d81a8), L64(0x966296c4f4315296),
    L64(0xf9c3f99b3aef62f9), L64(0xc533c566f697a3c5), L64(0x25942535b14a1025), L64(0x597959f220b2ab59),
    L64(0x842a8454ae15d084), L64(0x72d572b7a7e4c572), L64(0x39e439d5dd72ec39), L64(0x4c2d4c5a6198164c),
    L64(0x5e655eca3bbc945e), L64(0x78fd78e785f09f78), L64(0x38e038ddd870e538), L64(0x8c0a8c148605988c),
    L64(0xd163d1c6b2bf17d1), L64(0xa5aea5410b57e4a5), L64(0xe2afe2434dd9a1e2), L64(0x6199612ff8c24e61),
    L64(0xb3f6b3f1457b42b3), L64(0x21842115a5423421), L64(0x9c4a9c94d625089c), L64(0x1e781ef0663cee1e),
    L64(0x4311432252866143), L64(0xc73bc776fc93b1c7), L64(0xfcd7fcb32be54ffc), L64(0x0410042014082404),
    L64(0x515951b208a2e351), L64(0x995e99bcc72f2599), L64(0x6da96d4fc4da226d), L64(0x0d340d68391a650d),
    L64(0xfacffa8335e979fa), L64(0xdf5bdfb684a369df), L64(0x7ee57ed79bfca97e), L64(0x2490243db4481924),
    L64(0x3bec3bc5d776fe3b), L64(0xab96ab313d4b9aab), L64(0xce1fce3ed181f0ce), L64(0x1144118855229911),
    L64(0x8f068f0c8903838f), L64(0x4e254e4a6b9c044e), L64(0xb7e6b7d1517366b7), L64(0xeb8beb0b60cbe0eb),
    L64(0x3cf03cfdcc78c13c), L64(0x813e817cbf1ffd81), L64(0x946a94d4fe354094), L64(0xf7fbf7eb0cf31cf7),
    L64(0xb9deb9a1676f18b9), L64(0x134c13985f268b13), L64(0x2cb02c7d9c58512c), L64(0xd36bd3d6b8bb05d3),
    L64(0xe7bbe76b5cd38ce7), L64(0x6ea56e57cbdc396e), L64(0xc437c46ef395aac4), L64(0x030c03180f061b03),
    L64(0x5645568a13acdc56), L64(0x440d441a49885e44), L64(0x7fe17fdf9efea07f), L64(0xa99ea921374f88a9),
    L64(0x2aa82a4d8254672a), L64(0xbbd6bbb16d6b0abb), L64(0xc123c146e29f87c1), L64(0x535153a202a6f153),
    L64(0xdc57dcae8ba572dc), L64(0x0b2c0b582716530b), L64(0x9d4e9d9cd327019d), L64(0x6cad6c47c1d82b6c),
    L64(0x31c43195f562a431), L64(0x74cd7487b9e8f374), L64(0xf6fff6e309f115f6), L64(0x4605460a438c4c46),
    L64(0xac8aac092645a5ac), L64(0x891e893c970fb589), L64(0x145014a04428b414), L64(0xe1a3e15b42dfbae1),
    L64(0x165816b04e2ca616), L64(0x3ae83acdd274f73a), L64(0x69b9696fd0d20669), L64(0x092409482d124109),
    L64(0x70dd70a7ade0d770), L64(0xb6e2b6d954716fb6), L64(0xd067d0ceb7bd1ed0), L64(0xed93ed3b7ec7d6ed),
    L64(0xcc17cc2edb85e2cc), L64(0x4215422a57846842), L64(0x985a98b4c22d2c98), L64(0xa4aaa4490e55eda4),
    L64(0x28a0285d88507528), L64(0x5c6d5cda31b8865c), L64(0xf8c7f8933fed6bf8), L64(0x86228644a411c286),
};

#endif

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: sw=4 ts=4 fdm=marker
 * vim<600: sw=4 ts=4
 */
