package tileStyle;

/**
 * @author Yuriy Brun
 * 
 * The TileTypeException is an exception native to the tileStyle package.  It is used 
 * in a number of exceptional situations within the package.
 */
public class TileStyleException extends RuntimeException {
	
	public static final long serialVersionUID = 1L;
	
	/*
	 * Creates a new TileTypeException
	 */
	public TileStyleException() {
		super();
	}
	
	/*
	 * Creates a new TileTypeException with a message
	 * @param String message   the exceptional message
	 */
	public TileStyleException(String message){
		super(message);
	}
	
	/*
	 * Creates a new TileTypeException with a message and a cause
	 * @param String message   the exceptional message
	 * @param Throwable cause  the exception cause
	 */
	public TileStyleException(String message, Throwable cause) {
		super(message, cause);
	}
	
	/*
	 * Creates a new TileTypeException with a cause
	 * @param Throwable cause  the exception cause
	 */
	public TileStyleException(Throwable cause) {
		super(cause);
	}
}
