package tileStyle;

import Prism.core.AbstractImplementation;
import Prism.core.Brick;
import Prism.core.Component;
import Prism.core.Event;
import Prism.core.IPort;
import Prism.core.Port;
import Prism.extensions.port.ExtensiblePort;

public abstract class TileStyleComponent extends Component {
	
	protected TileStyleComponent(String name) {
		super(name);
	}

	protected TileStyleComponent(String name, AbstractImplementation implementation) {
		super(name, implementation);
	}
	
	/*
	 * This method sends the event up/down the Prism architecture that this component is a
	 * part of.
	 *
	 * @param Event e : Event to be sent.
	 * @param Port destination : the Port to which to send e.
	 */   
	public void send(Event e, Port destination)	{
		if (TileStyleStarter.DEBUG)
			System.out.println(this + " is sending event of type " + e.getClass() + " to " + destination);
		e.originatingBrick = this;
		if (destination.getPortType() == e.eventType) {
			if (destination instanceof ExtensiblePort) {
				e.handlingBrick = (Brick) destination;
				add(e);
			}
			else if (destination instanceof Port) {
				IPort mutualPort = destination.getMutualPort();
				e.handlingBrick = mutualPort.getParentBrick();
				add(e);
			}                        
		}
	}
}
