package tileStyle;

import java.io.*;
import java.util.*;

public class ResultAnalyzer {

	/**
	 * @param args
	 */
	public static void main(String[] args) throws IOException{
		String directory = args[0];
		String outFilename = args[1];
		
		File top = new File(directory);
		if (!(top.isDirectory())) 
			throw new IOException("The first argument should be a directory of tile style output files");
		File[] files = top.listFiles(new OutFileFilter());
		
		BufferedWriter outFile = new BufferedWriter(new FileWriter(outFilename));
		for (int i = 0; i < files.length; i++) {
			StringTokenizer tokens = new StringTokenizer(files[i].getName(), "."); 
			outFile.write(tokens.nextToken().trim() + "\t" +
					tokens.nextToken().trim() + "\t" +
					tokens.nextToken().trim() + "\t");
			
			BufferedReader data = new BufferedReader(new FileReader(files[i]));
			for (int j = 0; j < 6; j++) {
				String line = data.readLine();
				int lastSpace = line.lastIndexOf(" ");
				String name = line.substring(0, lastSpace);
				String millis = line.substring(lastSpace + 1);
				outFile.write(name + "\t" + millis + "\t");
			}
			outFile.newLine();
			data.close();
		}
		outFile.close();
	}

	protected static class OutFileFilter implements FileFilter {
		
		public OutFileFilter() {
			super();
		}
		
		public boolean accept(File file) {
			return (file.getName().endsWith(".out"));
		}
	}
}
