/**
 * 
 */
package tileStyle.Prism.events;

import Prism.core.PrismConstants;
import Prism.extensions.evt.ExtensibleEvent;
import tileStyle.Prism.*;

/**
 * @author Yuriy
 *
 */
public abstract class TileStyleEvent extends ExtensibleEvent {
	
	protected NodeAddress returnAddress;

	/**
	 * @param String name : the name of this event
	 * Creates a new TileStyleEvent with the specified name.
	 */
	public TileStyleEvent(String name) {
		super(name);
		this.eventType = PrismConstants.REQUEST;
	}
	
	public TileStyleEvent(String name, NodeAddress returnAddress) {
		this(name);
		this.returnAddress = returnAddress;
	}
	
	public NodeAddress getReturnAddress() {
		return returnAddress;
	}
	
//	public Port getReplyTo() {
//		return (Port) originatingBrick;
//	}
	
	/**
	 * @param TileStyleEvent eventClone : target for the clone 
	 * Replicates this into eventClone
	 */
//	void replicate(TileStyleEvent eventClone) {
//		eventClone.parameterName = super.parameterName;
//		eventClone.parameterValue = super.parameterValue;
//		eventClone.originatingBrick = super.originatingBrick;
//		eventClone.handlingBrick = super.handlingBrick;
//		eventClone.eventType = super.eventType;
//	}

}
