/**
 * 
 */
package tileStyle.Prism.events;

import Prism.core.Event;
import java.io.Serializable;

/**
 * @author Yuriy
 *
 */
public class SignInEvent extends TileStyleEvent implements Serializable {

	public static final long serialVersionUID = 1L;
	
	protected String hostname;
	
	public SignInEvent(String name, String hostname) {
		super(name);
		this.hostname = hostname;
	}
	
	public String getHostname() {
		return hostname;
	}
	
	public Event replicate() {
		SignInEvent e = new SignInEvent(new String(name), new String(hostname));
		e.parameterName = parameterName;
		e.parameterValue = parameterValue;
		e.originatingBrick = originatingBrick;
		e.handlingBrick = handlingBrick;
		e.eventType = eventType;
		return e;
	}
}
