package tileStyle.Prism.events;

import Prism.core.Event;
import tileStyle.Prism.*;
import java.io.Serializable;

public class SetNeighborEvent extends TileStyleEvent implements Serializable {

	public static final long serialVersionUID = 1L;
	
	protected TileAddress newbornAddress, address;
	int direction;
	
	public SetNeighborEvent(TileAddress newbornAddress, TileAddress address, int direction) {
		super("Set me as a neighbor");
		this.newbornAddress = newbornAddress;
		this.address = address;
		this.direction = direction;
	}

	public TileAddress getNewbornAddress() {
		return newbornAddress;
	}

	public TileAddress getAddress() {
		return address;
	}

	public int getDirection() {
		return direction;
	}
	
	public Event replicate() {
		return new SetNeighborEvent(newbornAddress, address, direction);
	}
}