package tileStyle.Prism.events;

import Prism.core.Event;
import tileStyle.Prism.*;
import java.io.Serializable;

public class GotSidesEvent extends TileStyleEvent implements Serializable {
	
	public static final long serialVersionUID = 1L;
	
	protected TileAddress northAddress, westAddress, homeAddress;
	int northsSide, westsSide;

	public GotSidesEvent(TileAddress northAddress, TileAddress westAddress, TileAddress homeAddress, int northsSide, int westsSide) {
		super("Got both sides");
		this.northAddress = northAddress;
		this.westAddress = westAddress;
		this.homeAddress = homeAddress;
		this.northsSide = northsSide;
		this.westsSide = westsSide;
	}

	public TileAddress getNorthAddress() {
		return northAddress;
	}

	public TileAddress getWestAddress() {
		return westAddress;
	}

	public TileAddress getHomeAddress() {
		return homeAddress;
	}

	public int getNorthsSide() {
		return northsSide;
	}

	public int getWestsSide() {
		return westsSide;
	}
	
	public Event replicate() {
		return new GotSidesEvent(northAddress, westAddress, homeAddress, northsSide, westsSide);
	}

}
