package tileStyle.Prism.events;

import Prism.core.Event;
import tileStyle.Prism.*;
import java.io.Serializable;

public class GetWestsSideEvent extends TileStyleEvent implements Serializable {

	public static final long serialVersionUID = 1L;
	
	protected TileAddress northAddress, westAddress, homeAddress;
	int northsSide;

	public GetWestsSideEvent(TileAddress northAddress, TileAddress westAddress, TileAddress homeAddress, int northsSide) {
		super("Getting west side");
		this.northAddress = northAddress;
		this.westAddress = westAddress;
		this.homeAddress = homeAddress;
		this.northsSide = northsSide;
	}

	public TileAddress getNorthAddress() {
		return northAddress;
	}

	public TileAddress getWestAddress() {
		return westAddress;
	}

	public TileAddress getHomeAddress() {
		return homeAddress;
	}

	public int getNorthsSide() {
		return northsSide;
	}
	
	public Event replicate() {
		return new GetWestsSideEvent(northAddress, westAddress, homeAddress, northsSide);
	}
}
