package tileStyle.Prism.events;

import Prism.core.Event;
import tileStyle.Prism.*;
import java.io.Serializable;

public class GetNorthsSideEvent extends TileStyleEvent implements Serializable {

	public static final long serialVersionUID = 1L;
	
	protected TileAddress northAddress, westAddress, homeAddress;

	public GetNorthsSideEvent(TileAddress northAddress, TileAddress westAddress, TileAddress homeAddress) {
		super("Getting north side");
		this.northAddress = northAddress;
		this.westAddress = westAddress;
		this.homeAddress = homeAddress;
	}

	public TileAddress getNorthAddress() {
		return northAddress;
	}

	public TileAddress getWestAddress() {
		return westAddress;
	}

	public TileAddress getHomeAddress() {
		return homeAddress;
	}
	
	public Event replicate() {
		return new GetNorthsSideEvent(northAddress, westAddress, homeAddress);
	}
}
