package tileStyle.Prism.events;

import Prism.core.Event;
import tileStyle.Prism.*;
import tileStyle.*;
import java.io.Serializable;

public class CreateReplicateRequest extends TileStyleEvent implements Serializable {

	public static final long serialVersionUID = 1L;

	protected int assemblyID;
	protected TileAddress[] neighbors;
	protected int fromInNodeID;
	protected TileType type;
	
	public CreateReplicateRequest(TileType type, int assemblyID, TileAddress[] neighbors, int fromInNodeID, NodeAddress returnAddress) {
		super("create replicate" + assemblyID, returnAddress);
		this.assemblyID = assemblyID;
		this.neighbors = neighbors;
		this.fromInNodeID = fromInNodeID;
		this.type = type;
	}
	
	public TileType getType() {
		return type;
	}
	
	public int getAssemblyID() {
		return assemblyID;
	}

	public TileAddress[] getNeighbors() {
		return neighbors;
	}
	
	public int getFromInNodeID() {
		return fromInNodeID;
	}
	
	public Event replicate() {
		return new CreateReplicateRequest(type, assemblyID, neighbors, fromInNodeID, returnAddress);
	}
}