package tileStyle.Prism.events;

import tileStyle.Prism.*;
import Prism.core.Event;
import java.io.Serializable;

public class CreateReplicateReply extends TileStyleEvent implements Serializable {
	
	public static final long serialVersionUID = 1L;

	protected int assemblyID;
	protected TileAddress address;
	protected int toInNodeID;
	
	public CreateReplicateReply(TileAddress address, int assemblyID, int toInNodeID) {
		super("created replicate" + assemblyID);
		this.assemblyID = assemblyID;
		this.address = address;
		this.toInNodeID = toInNodeID;
	}
	
	public int getAssemblyID() {
		return assemblyID;
	}

	public TileAddress getAddress() {
		return address;
	}
	
	public int getToInNodeID() {
		return toInNodeID;
	}
	
	public Event replicate() {
		return new CreateReplicateReply(address, assemblyID, toInNodeID);
	}
}