package tileStyle.Prism.events;

import Prism.core.Event;
import java.io.Serializable;

public class ClientSetEvent extends TileStyleEvent implements Serializable {
	
public static final long serialVersionUID = 1L;
	
	protected String hostname;
	
	public ClientSetEvent(String name, String hostname) {
		super(name);
		this.hostname = hostname;
	}
	
	public String getHostname() {
		return hostname;
	}
	
	public Event replicate() {
		ClientSetEvent e = new ClientSetEvent(new String(name), new String(hostname));
		e.parameterName = parameterName;
		e.parameterValue = parameterValue;
		e.originatingBrick = originatingBrick;
		e.handlingBrick = handlingBrick;
		e.eventType = eventType;
		return e;
	}

}
