package tileStyle.Prism.events;

import Prism.core.*;
import tileStyle.Prism.*;
import tileStyle.TileStyleException;
import java.io.Serializable;


/**
 * @author Yuriy
 *
 */
public class ChildUpdateResponse extends TileStyleEvent implements Serializable {
	
	public static final long serialVersionUID = 1L;

	protected int assemblyID;
	protected TileAddress childAddress;
	protected int direction;
	protected int toInNodeID;

	
	public ChildUpdateResponse(TileAddress childAddress, int direction, int assemblyID, int toInNodeID) {
		super("sending child");
		this.assemblyID = assemblyID;
		this.childAddress = childAddress;
		this.direction = direction;
		this.toInNodeID = toInNodeID;
	}
	
	public void setChild(TileAddress child) {
		if (childAddress == null)
			childAddress = child;
		else
			throw new TileStyleException("Tried to reset a ChildUpdateResponse's child when it was already not null");
	}
	
	public TileAddress getAddress() {
		return childAddress;
	}
	
	public int getAssemblyID() {
		return assemblyID;
	}
	
	public int getDirection() {
		return direction;
	}
	
	public int getToInNodeID() {
		return toInNodeID;
	}

	public Event replicate() {
		return new ChildUpdateResponse(childAddress, direction, assemblyID, toInNodeID);
	}
}
