package tileStyle.Prism.events;

import Prism.core.*;
import tileStyle.Prism.*;
import java.io.Serializable;

/**
 * @author Yuriy
 *
 */
public class ChildUpdateRequest extends TileStyleEvent implements Serializable {
	
	public static final long serialVersionUID = 1L;

	protected int assemblyID;
	protected int direction;
	protected int fromInNodeID;
	protected int toInNodeID;
	
	public ChildUpdateRequest(int assemblyID, int direction, int fromInNodeID, int toInNodeID, NodeAddress returnAddress) {
		super("get child", returnAddress);
		this.assemblyID = assemblyID;
		this.direction = direction;
		this.fromInNodeID = fromInNodeID;
		this.toInNodeID = toInNodeID;
	}
	
	public int getAssemblyID() {
		return assemblyID;
	}
	
	public int getFromInNodeID() {
		return fromInNodeID;
	}
	
	public int getToInNodeID() {
		return toInNodeID;
	}

	public int getDirection() {
		return direction;
	}
	
	public Event replicate() {
		return new ChildUpdateRequest(assemblyID, direction, fromInNodeID, toInNodeID, returnAddress);
	}
}
