package tileStyle.Prism.events;

import tileStyle.Prism.*;
import tileStyle.*;
import Prism.core.*;
import java.io.Serializable;

public class AttachTileEvent extends TileStyleEvent implements Serializable {

	public static final long serialVersionUID = 1L;
	
	protected TileAddress northAddress, westAddress;
	int assemblyID;
	protected TileType type;
	
	public AttachTileEvent(TileAddress northAddress, TileAddress westAddress, int assemblyID, TileType type) {
		super("Set me as a neighbor");
		this.northAddress = northAddress;
		this.westAddress = westAddress;
		this.assemblyID = assemblyID;
		this.type = type;
	}
	
	public TileType getType() {
		return type;
	}

	public TileAddress getNorthAddress() {
		return northAddress;
	}

	public TileAddress getWestAddress() {
		return westAddress;
	}

	public int getAssemblyID() {
		return assemblyID;
	}
	
	public Event replicate() {
		return new AttachTileEvent(northAddress, westAddress, assemblyID, type);
	}
}
