package tileStyle.Prism.events;

import java.util.*;
import Prism.core.*;
import tileStyle.TileType;
import tileStyle.Prism.NodeAddress;
import java.io.Serializable;

public class AddressMapEvent extends TileStyleEvent implements Serializable {
	
	public static final long serialVersionUID = 1L;
	
	protected Map<TileType, List<NodeAddress>> addresses;
	
	public AddressMapEvent(String name, Map<TileType, List<NodeAddress>> addresses) {
		super(name);
		this.addresses = addresses;
	}
	
	public Map<TileType, List<NodeAddress>> getAddresses() {
		return addresses;
	}
	
	public Event replicate() {
		AddressMapEvent e = new AddressMapEvent (new String(name), new HashMap<TileType, List<NodeAddress>>(addresses));
		e.parameterName = parameterName;
		e.parameterValue = parameterValue;
		e.originatingBrick = originatingBrick;
		e.handlingBrick = handlingBrick;
		e.eventType = eventType;
		return e;
	}

}