package tileStyle.Prism;

import java.io.Serializable;
import tileStyle.*;

// Immutable
/* Note that the node field may be set and the isLocal value can change throughout the life
   of this object, but those fields do not affect this objects immutable value
   */
public class NodeAddress implements Serializable {
	
	public static final long serialVersionUID = 1L;
	
	protected Node node;
	protected String hostname;
	protected int uniqueID, port;
	protected boolean forSeed;
	
	public NodeAddress(String hostname, int uniqueID, int port) {
		this.hostname = hostname;
		this.uniqueID = uniqueID;
		this.port = port;
		this.node = null;
		forSeed = false;
	}
	
	public NodeAddress(String hostname, int uniqueID, int port, boolean forSeed) {
		this(hostname, uniqueID, port);
		this.forSeed = forSeed;
	}
	
	public NodeAddress(String hostname, int uniqueID, int port, Node node) {
		this(hostname, uniqueID, port);
		this.node = node;
	}
	
	public NodeAddress(String hostname, int uniqueID, int port, Node node, boolean forSeed) {
		this(hostname, uniqueID, port, node);
		this.forSeed = forSeed;
	}
	
	public NodeAddress(NodeAddress original) {
		this.hostname = original.hostname;
		this.uniqueID = original.uniqueID;
		this.port = original.port;
		this.node = original.node;
		this.forSeed = original.forSeed;
	}
	
	public boolean isForSeed() {
		return forSeed;
	}
	
	public void setNode(Node node) {
		this.node = node;
	}
	
	public boolean isOnHost(String onHostname) {
		return hostname.equals(onHostname);
	}
	
	public Node getNode() {
		return node;
	}
	
	public String getHostname() {
		return hostname;
	}
	
	public int getUniqueID() {
		return uniqueID;
	}

	public int getPort() {
		return port;
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((hostname == null) ? 0 : hostname.hashCode());
		result = prime * result + port;
		result = prime * result + uniqueID;
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final NodeAddress other = (NodeAddress) obj;
		if (hostname == null) {
			if (other.hostname != null)
				return false;
		} else if (!hostname.equals(other.hostname))
			return false;
		if (port != other.port)
			return false;
		if (uniqueID != other.uniqueID)
			return false;
		return true;
	}
	
	
}