package tileStyle;

import java.io.*;
import java.util.*;

public class DistributedTileFileCreator {

	/**
	 * @param args
	 */
	public static void main(String[] args) throws IOException {
		// reads a file for tiles
		// reads a file for IPs
		// writes out the .tiles v 0.3 file
		
		String tileFilename = args[0];
		String ipFilename = args[1];
		String outFilename = args[2];
		
		List<String> tiles = new ArrayList<String>();
		List<String> ips = new ArrayList<String>();
		int computes = 49; //FOR SUBSETSUM ONLY!!!  computes is the number of compute tiles
		
		BufferedReader tileFile = new BufferedReader(new FileReader(tileFilename));
		String line = tileFile.readLine();
		while (line != null) {
			if (!(line.startsWith("%")))
				tiles.add(line.trim());
			line = tileFile.readLine();
		}
		tileFile.close();
		
		BufferedReader ipFile = new BufferedReader(new FileReader(ipFilename));
		line = ipFile.readLine();
		while (line != null) {
			ips.add(line.trim());
			line = ipFile.readLine();
		}
		
		BufferedWriter outFile = new BufferedWriter(new FileWriter(outFilename));
		outFile.write("%Tiles file version 0.3");
		outFile.newLine();
		outFile.write("%Autogenerated by DistributedTileFileCreator on " + System.currentTimeMillis());
		outFile.newLine();
		
		for (int i = 0; i < tiles.size(); i++) {
			if (tiles.get(i).startsWith("input"))
				outFile.write(tiles.get(i));
			else
				if (computes > (8 * ips.size()))
					outFile.write(tiles.get(i) + "," + 
							ips.get((int) (i * ips.size() / computes)) + "," + 
							(2601 + i));
				else if (i < 8)
					outFile.write(tiles.get(i) + "," + ips.get(0) + "," + (2601 + i));
				else
					outFile.write(tiles.get(i) + "," + 
							ips.get((int) (i % (ips.size() - 1) + 1)) + "," + 
							(2601 + i));
			outFile.newLine();
		}
		outFile.close();
	

	}

}
