from __future__ import division
import random

def trainPerceptron(examples, stepSize=None, numPasses=None, useAveraging=True, evalCallback=None, averagedEvalCallback=None, useShuffling=True, **moreArgsToIgnore):
    # examples: list of  (label, featvec) pairs
    # the label is boolean
    # the featvecs are dictionaries

    weights = {}

    if useAveraging:
        weightSums = {}  # the 'S' vector from PS3, for the averaged perceptron.
        t = 0

    for pass_iteration in range(numPasses):
        print "Training on %d'th pass through the training set" % pass_iteration
        shuffled_examples = examples[:]   # make a copy of the list
        if useShuffling:
            print "Shuffling examples"
            random.shuffle(shuffled_examples)
        for (label,featvec) in shuffled_examples:

    # for pass_iteration in range(numPasses):
    #     print "pass",pass_iteration
    #     for _i in range(len(examples)):

            if useAveraging: t += 1
            score = linearModelScore(featvec, weights)
            # if there's an error, update
            # if (label and score <= 0) or (not label and score >= 0):  # BUG
            if (label and score <= 0) or (not label and score > 0): 
                delta = 1 if label else -1
                for feat in featvec.iterkeys():
                    if feat not in weights:
                        weights[feat] = 0
                    weights[feat] += stepSize * delta * featvec[feat]

                    # if useAveraging and pass_iteration >= 1:
                    if useAveraging:
                        if feat not in weightSums:
                            weightSums[feat] = 0
                        if useAveraging:
                            weightSums[feat] = weightSums[feat] + (t-1) * stepSize * delta * featvec[feat]

        # print "%d changes" % num_changes

        if evalCallback is not None:
            evalCallback(weights)
        if averagedEvalCallback is not None:
            print "averaged:",
            avgWeights = {}
            for feat in weightSums:
                avgWeights[feat] = weights[feat] - 1/t * weightSums[feat]
            averagedEvalCallback(avgWeights)
            import sys
            sys.stdout.flush()
            # print

    print "Learned weights for %d features from %d examples" % (len(weights), len(examples))

    if not useAveraging:
        return weights
    else:
        avgWeights = {}
        for feat in weightSums:
            avgWeights[feat] = weights[feat] - 1/t * weightSums[feat]
        return avgWeights

def linearModelScore(featvec, model):
    # this computes the dot product between a feature vector and the model's weight vector.
    #  - featvec: dictionary that repesents a sparse vector of feature values
    #  - model: dictionary that represents a sparse vector of the weights
    score = 0
    for key in featvec.iterkeys():
        score += model.get(key,0)
    return score

def printExtremeWeights(model):
    items = model.items()
    items.sort(key=lambda (name,value): -value)
    print "%d total features, showing highest and lowest weights" % len(items)
    print "Top weights:"
    print items[:10]
    print "Bottom weights:"
    items.sort(key=lambda (name,value): value)
    print items[:10]

def smallPerceptronTest():
    import classutil

    print "Loading data"
    train_examples = classutil.read_train_data()
    test_examples = classutil.read_test_data()

    print "Num pos vs negative in test set: %s pos, %s neg, %s total" % (
            sum( int(y) for (y,x) in test_examples ),
            sum( int(not y) for (y,x) in test_examples ),
            len(test_examples) )

    def evalClassifier(weights):
        correct = 0
        for y,ex in test_examples:
            score = linearModelScore(ex, weights)
            correct += int( (y and score>0) or (not y and score <= 0) )
        print "Classifier accuracy = %d/%d = %s" % (correct, len(test_examples), correct/len(test_examples))

    print "Training perceptron"

    # model = trainPerceptron(train_examples, 
    #             numPasses=5,
    #             stepSize=1,
    #             evalCallback=evalClassifier,
    #             useShuffling=False)

    model = trainPerceptron(train_examples, numPasses=100, stepSize=1, evalCallback=evalClassifier, useShuffling=False, useAveraging=True, averagedEvalCallback=evalClassifier)

    # model = trainPerceptron(train_examples, numPasses=100, stepSize=1, evalCallback=evalClassifier, useShuffling=False, useAveraging=False)
    # model = trainPerceptron(train_examples, numPasses=100, stepSize=1, evalCallback=evalClassifier, useShuffling=False, useAveraging=True)
    # model = trainPerceptron(train_examples, numPasses=10, stepSize=1, evalCallback=evalClassifier, useShuffling=True, useAveraging=True, averagedEvalCallback=evalClassifier)
    # model = trainPerceptron(train_examples, numPasses=30, stepSize=1, evalCallback=evalClassifier, useShuffling=True, useAveraging=False)
    # model = trainPerceptron(train_examples, numPasses=20, stepSize=1, evalCallback=evalClassifier, useAveraging=True)

    print "Accuracy of final model:"
    evalClassifier(model)
    printExtremeWeights(model)



if __name__=='__main__':
    smallPerceptronTest()

