# This script loads one document you specify on the commandline, 
# and prints out all sentences and mentions.
# You can edit it to test your mention analysis functions, like isPlural() or whatever.

import sys
from pprint import pprint
import corefutil

documents = corefutil.loadJson(sys.argv[1])

for docnum, doc in enumerate(documents):
    print "DOC %d" % docnum
    for sentnum,sent in enumerate(doc['sentences']):
        print
        print "SENTENCE S%d" % sentnum
        print sent
        ments_in_this_sentence = [m for m in doc['mentions'] if m['sentenceIndex'] == sentnum]
        for ment in ments_in_this_sentence:
            # this is just for a cleaner pretty-print
            ment_without_sentpointer = {k:v for k,v in ment.items() if k != 'sentence'}

            print
            print "MENTION [%s]" % corefutil.mentionString(ment)
            pprint(ment_without_sentpointer)

            # Here is a good place to print the results of functions you want to test.  For example,
            # import coref
            # print "is pronoun?", coref.isPronoun(ment)
            # print "is plural?", coref.isPlural(ment)


