from __future__ import division
from pprint import pprint
import sys

import corefutil # you will not change this

#----------------------------Start Mention Feature Code---------------------------------------

def isPronoun(ment):
    # this returns True if the mention is a pronoun
    #Answer Starts Here
    return True
    #Answer Ends Here

def isProper(ment):
    # this returns True if the mention is a proper noun phrase (you should
    # implement a heuristic method for detecting proper-ness based on the given
    # POS tag for the head token). 
    #Answer Starts Here
    return True
    #Answer Ends Here

def isPlural(ment):
    # this returns True if the mention is plural (you should implement a
    # heuristic method for detecting plural-ness based on the given POS tag for
    # the head token). 
    #Answer Starts Here
    return True
    #Answer Ends Here

#----------------------------Start Stuff for Rule-Based Coref---------------------------------------

def isAcceptableAntecedent(mention,candidateAntecedent):
    # For a given mention, deterministic coref assigns the mention to the first
    # mention to the left that satisfies this function.  If no mention (in a
    # window) satisfies the function, then it does not make any coreferencing
    # link.

    # print "CURRENT", mention
    # print "CANDIDATE", candidateAntecedent

    return False


def rule1(ment, cand):
    return False

def rule2(ment, cand):
    return False

def rule3(ment, cand):
    return False

def doRuleCoref(documents, testSettings,verbose=False):
    # This performs rule-based coref on the documents. For each document, it
    # adds a field 'coref' this is a list of coreference links.
    # The links are in the form of a dictionary, where links[i]  = j represents
    # that mention i is linked to mention j, where j is i's antecedent.  So j
    # is to the left of i.
    windowWidth = testSettings['windowWidth']
    for doc in documents:
        if 'coref' in doc: del doc['coref']   # Delete the old predictions if any exist
        links = {}
        mentions = doc['mentions']
        for mi in range(1, len(mentions)):
            if verbose:
                print "Processing mention: %s" % corefutil.mentionString(mentions[mi])
            # the last up-to-windowWidth indexes
            leftInd = max(0, mi - windowWidth)
            candInds = list(reversed(range(leftInd, mi)))
            acceptableInds = [mj for mj in candInds if isAcceptableAntecedent(mentions[mi], mentions[mj])]
            if not acceptableInds:
                choice = None
            else:
                choice = acceptableInds[0]
            if choice is not None:
                links[mi] = choice

            if verbose:
                for mj in candInds:
                    print " Candidate= %s" % corefutil.mentionString(mentions[mj])
                    print " gold = %d, acceptable = %d, chosen = %d" % (
                            corefutil.entityIdForMention(mentions[mi]) ==  corefutil.entityIdForMention(mentions[mj]),  
                            mj in acceptableInds,
                            choice==mj)
        ## Stores the links in the document object.
        doc['coref'] = links

#---------End Stuff for Rule-Based Coref----------


#---------Start Experiment Drivers and Main Function------------        

def main():
    import argparse
    p = argparse.ArgumentParser()
    p.add_argument('test_file')
    args = p.parse_args()
    
    testDocuments = corefutil.loadJson(args.test_file)
    
    testSettings = {}
    testSettings['windowWidth'] = 5

    doRuleCoref(testDocuments, testSettings, verbose=False)
    corefutil.evalCorefPairwise(testDocuments)

    # Viewing one or more documents
    # docinds = [0]
    # # docinds = [3]   # the Bob Stone document in test.json
    # # docinds = range(5)  # first 5 documents
    # for i in docinds:
    #     if len(testDocuments) <= i: continue
    #     print "Document",i
    #     corefutil.printDocument(testDocuments[i])

    ## Uncomment or tweak for a window sweep experiment
    # for w in range(1,11):
    #     print "window width", w
    #     doRuleCoref(testDocuments, {'windowWidth':w}, verbose=False)
    #     corefutil.evalCorefPairwise(testDocuments)



if __name__ == "__main__":
    main()


#----------------------------End Experiment Drivers and Main Function---------------------------------------

