/******************************
   File:     TAQAccess_ascii.h
   author:   Boulat A. Bash
   email:    boulat@alum.dartmouth.org
   created:  July 2003
   updated:  July 2003
   comments: Header file for C Routines to output TICK data to text file
******************************/

#ifndef TAQAccess_ASCII
#define TAQAccess_ASCII

#include "TAQAccess_tick.h"

struct sumprinterstruct {
  int s;
  int c;
  int n;
  int d;
  int u;
  int nt;
  int nq;
};
typedef struct sumprinterstruct SUM_PRINTER;

struct tradeprinterstruct {
  int s;
  int c;
  int d;
  int ex;
  int tim;
  int prc;
  int siz;
  int cond;
  int corr;
  int tseq;
  int g127;
};
typedef struct tradeprinterstruct TRADE_PRINTER;

struct quoteprinterstruct {
  int s;
  int c;
  int d;
  int ex;
  int tim;
  int bid;
  int bidsiz;
  int ofr;
  int ofrsiz;
  int mode;
  int qseq;
  int mmid;
};
typedef struct quoteprinterstruct QUOTE_PRINTER;
int tick_sum_write_ascii   (FILE *fp, TICK t, int spc, char d, char e,
                            SUM_PRINTER print);
int trade_write_ascii      (FILE *fp, TICK t,   long i, int spc, char d, char e,
                            TRADE_PRINTER print);
int quote_write_ascii      (FILE *fp, TICK t,   long i, int spc, char d, char e,
                            QUOTE_PRINTER print);
int tick_f_sum_write_ascii (FILE *fp, TICK_F t, int spc, char d, char e,
                             SUM_PRINTER print);
int trade_f_write_ascii    (FILE *fp, TICK_F t, long i, int spc, char d, char e,
                            TRADE_PRINTER print);
int quote_f_write_ascii    (FILE *fp, TICK_F t, long i, int spc, char d, char e,
                            QUOTE_PRINTER print);
void s_header_write_ascii  (FILE *fp, int spc, char d, char e,
                            SUM_PRINTER print);
void t_header_write_ascii  (FILE *fp, long date, int spc, char d, char e,
                            TRADE_PRINTER print);
void q_header_write_ascii  (FILE *fp, long date, int spc, char d, char e,
                            QUOTE_PRINTER print);
void print_symbol (FILE *fp, char *s,  int spc, char *d);
void print_cusip  (FILE *fp, char *c,  int spc, char *d);
void print_date   (FILE *fp, long dt,  int spc, char *d);
void print_ex     (FILE *fp, char ex,  int spc, char *d);
void print_tim    (FILE *fp, long t,   int spc, char *d);
void print_prc    (FILE *fp, double p, int spc, char *d);
void print_siz    (FILE *fp, long s,   int spc, char *d);
void print_cond   (FILE *fp, char *c,  int spc, char *d);
void print_corr   (FILE *fp, short c,  int spc, char *d);
void print_seq    (FILE *fp, long s,   int spc, char *d);
void print_g127   (FILE *fp, short g,  int spc, char *d);
void print_qsiz   (FILE *fp, long s,   int spc, char *d);
void print_mode   (FILE *fp, short m,  int spc, char *d);
void print_mmid   (FILE *fp, char *m,  int spc, char *d);
void print_name   (FILE *fp, char *n,  int spc, char *d);
void print_uot    (FILE *fp, long u,   int spc, char *d);
void print_n      (FILE *fp, long t,   int spc, char *d);
SUM_PRINTER   sum_print_all    ();
SUM_PRINTER   sum_print_none   ();
TRADE_PRINTER trade_print_all  ();
TRADE_PRINTER trade_print_none ();
QUOTE_PRINTER quote_print_all  ();
QUOTE_PRINTER quote_print_none ();

/* Format based on TAQ2 v.1.42b fixed-width ASCII format */
int  trades_write_taq2 (FILE *fp, TICK t, int spc, TRADE_PRINTER print);
int  quotes_write_taq2 (FILE *fp, TICK t, int spc, QUOTE_PRINTER print);

#endif


