function visualize_detected_objects(poselet_thumbs,all_label_masks,poselet_hits,torso_predictions,bounds_predictions,model,im)
global K;

if ~exist('bounds_predictions','var') || isempty(bounds_predictions)
   bounds_predictions=hit_records; 
end
if ~exist('torso_predictions','var') || isempty(torso_predictions)
   torso_predictions=hit_records; 
end
if ~exist('im','var')
   global im; 
end

% Convert label_masks to foreground/face/hair
fg_count = sum(all_label_masks(:,:,:,2:20),4);
bg_count = max(0,250 - sum(all_label_masks(:,:,:,[1 21 22]),4));
face_count = sum(all_label_masks(:,:,:,K.A_Face),4);
hair_count = sum(all_label_masks(:,:,:,K.A_Hair),4);
label_masks(:,:,:,2) = fg_count./double(fg_count+bg_count);
label_masks(:,:,:,3) = face_count./double(face_count+bg_count);
label_masks(:,:,:,1) = hair_count./double(hair_count+bg_count);
clear all_label_masks;
    
all_hits.poselet_hits=poselet_hits;
all_hits.torso_predictions=torso_predictions;
all_hits.bounds_predictions=bounds_predictions;
clear poselet_hits torso_predictions bounds_predictions;

warning('off','MATLAB:intConvertNonIntVal');

image_ids = unique([all_hits.poselet_hits.image_id; all_hits.torso_predictions.image_id; all_hits.bounds_predictions.image_id]);
if image_ids==0 % single image
   all_hits.poselet_hits.image_id(:)=1;
   all_hits.torso_predictions.image_id(:)=1;
   all_hits.bounds_predictions.image_id(:)=1; 
   image_ids=1;
end

display_bounds = false;
display_torsos = false;
display_poselets = true;
if all_hits.poselet_hits.size==0
    display_poselets = false;
    display_torsos=true;
end
part_changed = true;
img_changed  = true;
num2show_changed = true;
img_id = 1;
num2show = 1;

while 1
    if img_changed
        img = imread(image_file(image_ids(img_id),im));

        part_changed=true;
        hits_for_image = all_hits_for_image(all_hits,image_ids(img_id));
        part_idx = find(hits_for_image.poselet_hits.score==max(hits_for_image.poselet_hits.score),1);
    end

    if part_changed && display_poselets
        figure(3);
        montage(permute(poselet_thumbs{hits_for_image.poselet_hits.poselet_id(part_idx)}, [2,3,4,1]));
    elseif ~display_poselets && ishandle(3)
        close(3);
    end


    % Refresh image and redraw hit boxes
    if part_changed || img_changed || num2show_changed
        figure(1);
        clf;
        warning('off');
        imshow(rgb2gray(img));
        warning('on');
        hold on;

        title(sprintf('img: %d imgid: %d part: %d/%d prob thresh: %d%%',img_id,image_ids(img_id),all_hits.poselet_hits.poselet_id(part_idx),hits_for_image.poselet_hits.size,round(num2show)));

        if display_poselets
            ppp = hits_for_image.poselet_hits.select(part_idx);
            ppp.draw_bounds([0 1 0],2,':',[.7 .9 .7]);
            [obj_bounds,angle] = predict_bounds(ppp.bounds,ppp.angle,  model.hough_votes(ppp.poselet_id));
            hit_scale = ppp.bounds(3);
            bounds_sigma = model.hough_votes(ppp.poselet_id).obj_bounds_var*hit_scale;
            assert(angle==0);
            
            rectangle('position',obj_bounds,'edgecolor','b');
%             colors=jet(4);
%             for f=-2:2
%                 lw = 5-abs(f*2);
%                 line(repmat(obj_bounds(1)+bounds_sigma(1)*f,2,1), [obj_bounds(2); obj_bounds(2)+obj_bounds(4)],'linewidth',lw,'color',colors(1,:));
%                 line(repmat(sum(obj_bounds([1 3]))+bounds_sigma(3)*f,2,1), [obj_bounds(2); obj_bounds(2)+obj_bounds(4)],'linewidth',lw,'color',colors(2,:));
%                 line([obj_bounds(1); sum(obj_bounds([1 3]))],repmat(obj_bounds(2)+bounds_sigma(2)*f,2,1),'linewidth',lw,'color',colors(3,:));
%                 line([obj_bounds(1); sum(obj_bounds([1 3]))],repmat(sum(obj_bounds([2 4]))+bounds_sigma(4)*f,2,1),'linewidth',lw,'color',colors(4,:));
%             end
        end
        if display_torsos
            [ppp,sel] = select_h_thresh(hits_for_image.torso_predictions,num2show);
            if ~ppp.isempty
                ppp=select(ppp,ppp.size:-1:1); % order them weakest to strongest so bounds of strongest are drawn last            
                ppp.draw_bounds([0 0 0],5);
                ppp.draw_bounds([1 1 1],3,'--',[.7 .9 .7]);
            end
        end
        if display_bounds
            ppp = select_h_thresh(hits_for_image.bounds_predictions,num2show);
            [srt,srtd] = sort(ppp.score);
            ppp.select(srtd).draw_bounds([1 0 0],3,'--',[.7 .9 .7]);            
        end

    end
    part_changed=false;
    img_changed=false;
    num2show_changed = false;

    figure(1);
    while 1
        [x,y,ch] = ginput(1);
        if isscalar(ch) break; end
    end

    switch ch
        case 27 % ESC
            windows = 1:4;
            close(windows(ishandle(windows)));
            return;
        case 29 % ->
            if img_id<length(image_ids)
                img_id=img_id+1;
                img_changed=true;
            end

        case 28 % <-
            if img_id>1
                img_id=img_id-1;
                img_changed=true;
            end
        case 'g'
            answer = str2double(inputdlg('Enter index:'));
            if ~isempty(answer)
                answer = round(answer);
                if answer>0
                    img_id = min(answer,length(image_ids));
                    img_changed=true;
                end
            end

        case '-'
            if display_poselets
                [srt,srtd]=sort(hits_for_image.poselet_hits.score,'descend');
                qqq=find(part_idx==srtd,1);
                if qqq>1
                    part_idx = srtd(qqq-1);
                    part_changed=true;
                end
            end
        case '='
            if display_poselets
                [srt,srtd]=sort(hits_for_image.poselet_hits.score,'descend');
                qqq=find(part_idx==srtd,1);
                if qqq<length(srtd)
                    part_idx = srtd(qqq+1);
                    part_changed=true;
                end
            end

        case 'b'
            if isfield(hits_for_image,'bounds_predictions')
                display_bounds = true;
                display_torsos=false;
                display_poselets=false;
                part_changed=true;
            end
        case 't'
            display_torsos = true;
            display_bounds=false;
            display_poselets=false;
            part_changed=true;
        case 'p'
            display_poselets = true;
            display_torsos=false;
            display_bounds=false;
            part_changed = true;

        case ' '
            % find which bounds are selected
            ppp = select_h_thresh(hits_for_image.torso_predictions,num2show);
            bbb = select_h_thresh(hits_for_image.bounds_predictions,num2show);
            if display_torsos
                intersect = find(x>=ppp.bounds(:,1) & y>=ppp.bounds(:,2) & x<=sum(ppp.bounds(:,[1 3]),2) & y<=sum(ppp.bounds(:,[2 4]),2));
            else
                intersect = find(x>=bbb.bounds(:,1) & y>=bbb.bounds(:,2) & x<=sum(bbb.bounds(:,[1 3]),2) & y<=sum(bbb.bounds(:,[2 4]),2));                
            end
            if isscalar(intersect)
                visualize_hypothesis(poselet_thumbs, img, ppp.bounds(intersect,:), all_hits.poselet_hits.select(ppp.src_idx{intersect}), label_masks, bbb.bounds(intersect,:));
            end

        case 30 % /\
            num2show = num2show+1;
            num2show_changed=true;
        case 31 % \/
            if num2show>1
                num2show = max(1,num2show-1);
                num2show_changed=true;
            end
            
    end %switch
end % while 1
end % main

function [hits,sel]=select_h_thresh(hits, num2show)
[srt,srtd] = sort(hits.score,'descend');
num2show=min(length(srtd),num2show);
sel = srtd(1:num2show);
hits = hits.select(sel);
end

function all_hits=all_hits_for_image(all_hits, img_id)
all_hits.poselet_hits = all_hits.poselet_hits.select(all_hits.poselet_hits.image_id==img_id);
all_hits.torso_predictions = all_hits.torso_predictions.select(all_hits.torso_predictions.image_id==img_id);
all_hits.bounds_predictions = all_hits.bounds_predictions.select(all_hits.bounds_predictions.image_id==img_id);
end


function visualize_hypothesis(poselet_thumbs, img, bounds, poselet_hits, human_segs1, human_bounds)
fig3_rect=[];
human_segs = mean(human_segs1,4);
human_segs(:,1:2:end,1:2:end) = human_segs1(:,1:2:end,1:2:end,1);
human_segs(:,2:2:end,1:2:end) = human_segs1(:,2:2:end,1:2:end,2);
human_segs(:,1:2:end,2:2:end) = human_segs1(:,1:2:end,2:2:end,3);
human_segs(:,2:2:end,2:2:end) = human_segs1(:,2:2:end,2:2:end,1);
human_segs1 = mean(human_segs1,4);


[srt,srtd]=sort(poselet_hits.score,'descend');
poselet_hits=poselet_hits.select(srtd);

PAD = 3*[0.3 1] .* bounds(3:4);
bounds = bounds +[-PAD 2*PAD];
img = repmat(rgb2gray(img),[1 1 3]);
img = imcrop(img,bounds);
human_bounds(1:2) = human_bounds(1:2)-max(0,bounds(1:2));

tl = max(bounds(1:2),1);
poselet_hits.bounds(:,1:2) = poselet_hits.bounds(:,1:2) - repmat(tl,poselet_hits.size,1);

screen_bounds = [800 800];
scale = min(screen_bounds./[size(img,1) size(img,2)]);
warning off;
img = imresize(img,scale);
poselet_hits.bounds = poselet_hits.bounds * scale;
human_bounds = human_bounds*scale;

selected_poselets = false(poselet_hits.size,1);

thumbs = repmat(human_segs(poselet_hits.poselet_id,:,:),[1 1 1 3]);
%thumbs = human_segs(poselet_hits.poselet_id,:,:,:);
orig_thumbs = thumbs;


while true
    % Display the image and outlines of selected poselets
    im_draw = img;


    best_hits = poselet_hits.select(selected_poselets);
    best_hits.bounds = round(best_hits.bounds);

    colors = jet(best_hits.size);
    for i=1:best_hits.size
        hm = squeeze(human_segs1(best_hits.poselet_id(i),:,:,:));

        mask = imresize(hm,best_hits.bounds(i,[4 3]));
        mask = imdilate(edge(double(mask>0.1)),ones(3));

        img_mask = false(size(img,1),size(img,2));

        y_span=best_hits.bounds(i,2):(best_hits.bounds(i,2)+best_hits.bounds(i,4)-1);
        x_span=best_hits.bounds(i,1):(best_hits.bounds(i,1)+best_hits.bounds(i,3)-1);
        valid_y_span = y_span>0 & y_span<=size(im_draw,1);
        valid_x_span = x_span>0 & x_span<=size(im_draw,2);

        img_mask(y_span(valid_y_span), x_span(valid_x_span)) = mask(valid_y_span,valid_x_span);

        for j=1:3
            colored_mask(:,:,j) = cast(img_mask*colors(i,j)*255,'uint8');
        end
        im_draw(repmat(img_mask,[1 1 3])) = colored_mask(repmat(img_mask,[1 1 3]));
    end
    

    figure(11); clf;
    imshow(im_draw);
    hold on;
    rectangle('position',human_bounds,'edgecolor','r','linewidth',3);
    for i=1:best_hits.size
        best_hits.select(i).draw_bounds(colors(i,:));
    end

    if best_hits.size==1
        figure(3);
        if ~isempty(fig3_rect)
           set(3,'position',fig3_rect); 
        end
        montage(permute(poselet_thumbs{best_hits.poselet_id}, [2,3,4,1]));
    elseif ishandle(3)
        fig3_rect=get(3,'position');
        close(3);
    end
    
    title(sprintf('Showing the top %d of %d poselets',best_hits.size,poselet_hits.size));

    % Display examples from each poselet
    figure(10);

    [hhh,dims]=display_thumbs(thumbs,num2str(poselet_hits.score));

    while 1
        [x,y,ch] = ginput(1);
        if isscalar(ch) break; end
    end

    if ch==27 % ESC
       windows = [10 11];
       close(windows(ishandle(windows)));
       return;
    end

    y = floor(y/(size(thumbs,2)));
    x = floor(x/(size(thumbs,3)));
    idx = y*dims(2) + x+1;

    if idx>0 && idx<=poselet_hits.size
        selected_poselets(idx) = ~selected_poselets(idx);
        colors = jet(sum(selected_poselets));
    
        thumbs = orig_thumbs;
        selected_indices=find(selected_poselets);
        for i=1:length(selected_indices)
            for j=1:3
                thumbs(selected_indices(i),:,:,j) = thumbs(selected_indices(i),:,:,j)*colors(i,j);
            end
        end
    end
end
end


% Duplicated in cluster2bounds
function [bounds,angle] = predict_bounds(poselet_bounds, poselet_angle, poselet2bounds)
    % Given part hits generates a list of torso predictions for each image

    scale = min(poselet_bounds(3:4)); % The poselet normalized coords go from -0.5 to 0.5 along the shorter dimension
    image2poselet_ctr = poselet_bounds(1:2)+poselet_bounds(3:4)/2;
    rad_angle = poselet_angle*pi/180;
    poselet_rot = [cos(rad_angle) sin(rad_angle); -sin(rad_angle) cos(rad_angle)];

    scaled_bounds = poselet2bounds.obj_bounds * scale;
    poselet2bounds_ctr = scaled_bounds(1:2) + scaled_bounds(3:4)/2;
    bounds_dims = scaled_bounds(3:4);

    image2bounds_ctr = image2poselet_ctr + poselet2bounds_ctr*poselet_rot;        
    bounds = [image2bounds_ctr - bounds_dims/2 bounds_dims];
    angle = poselet_angle;
end

function [h,dims]=display_thumbs(samples, annotations, dims)

warning('off','Images:initSize:adjustingMag');

if length(samples)==0
    return;
end
    
if (length(size(samples))==3) 
    [N,H,W] = size(samples);
    s = permute(samples, [2,3,1]);
    if nargin<3
        h=montage(reshape(s, H,W,1,N));%, 'DisplayRange',[]);
    else
        h=montage(reshape(s, H,W,1,N), 'Size',dims);%, 'DisplayRange',[]);
    end
else
    [N,H,W,C] = size(samples);
    s = permute(samples, [2,3,4,1]);
    if nargin<3
        h=montage(reshape(s, H,W,C,N));%, 'DisplayRange',[]);   
    else
        h=montage(reshape(s, H,W,C,N), 'Size',dims);%, 'DisplayRange',[]);
    end
end


% figure out the dimensions used
im_sz = size(get(h,'CData'));
s_sz = size(samples);
if nargin<3
    dims = im_sz([2 1])./s_sz([3 2]);
end

% draw annotations
if exist('annotations','var') && ~isempty(annotations)
    for i=1:s_sz(1)
        text(mod(i-1,dims(1))*s_sz(3),floor((i-1)/dims(1))*s_sz(2)+8,annotations(i,:),...
            'BackgroundColor',[1 1 1],'Margin',0.0001,'FontSize',8);
    end
end
end

