function hits = nonmax_suppress_hits(hits)
% Removes any hits that overlap >0.5 with other hits that have higher score

poselet_ids = unique(hits.poselet_id)';
valid = false(hits.size,1);
for p=poselet_ids
    phits=find(hits.poselet_id==p);
    valid(phits(get_nonoverlapped_bounds(hits.bounds(phits,:),hits.score(phits),inf)))=true;
end
hits = hits.select(valid);
    
end