function pts=get_rot_corners(bounds, angle)
% returns a list of points that would be needed to draw the outline of 
% a rotated rectangle

ctr = bounds(1:2)+bounds(3:4)/2;

p1 = bounds(1:2);
p2 = p1 + bounds(3:4);
rad = angle*pi/180;

pts = [p1          1
       p2(1) p1(2) 1
       p2          1
       p1(1) p2(2) 1
       p1          1];
   
xform = [1 0 0; 0 1 0; -ctr 1] * ...
        [cos(rad) sin(rad) 0; -sin(rad) cos(rad) 0; 0 0 1] * ...
        [1 0 0; 0 1 0;  ctr 1];

pts = pts*xform;
pts = pts(:,1:2);
end