function idx = get_nonoverlapped_bounds(bounds,scores,max_hits)
% Given a set of possibly overlapping bounds and associated scores, returns
% the list of bounds that are not overlapped by more than 0.5 by other
% bounds with higher score

[srt,srtd] = sort(scores,'descend');

ibounds = [srtd bounds(srtd,:)];

i=1;
while i<size(ibounds,1) && i<max_hits
    suppressed = [zeros(i,1); bounds_overlap(ibounds(i,2:5), ibounds((i+1):end,2:5))>=0.5];
    ibounds = ibounds(~suppressed,:);
    i=i+1;
end

idx=ibounds(:,1);

end


% Returns intersection over union between the single bounds and each of many_bounds
function int_over_union = bounds_overlap(bounds, many_bounds)
    int_over_union = zeros(size(many_bounds,1),1,'single');
    
    x0 = max(bounds(1),many_bounds(:,1));
    x1 = min(bounds(3)+bounds(1),many_bounds(:,3)+many_bounds(:,1));
    sel_x = find(x1>x0);

    y0 = max(bounds(2),many_bounds(sel_x,2));
    y1 = min(bounds(4)+bounds(2),many_bounds(sel_x,4)+many_bounds(sel_x,2));    
    sel_y = y1>y0;
    
    sel = sel_x(sel_y);
    if ~isempty(sel)
        int_area = (x1(sel)-x0(sel)) .* (y1(sel_y)-y0(sel_y));
        int_over_union(sel) = int_area ./ (many_bounds(sel,3).*many_bounds(sel,4) - int_area +  bounds(3)*bounds(4));
    end
end