function bounds_predictions = get_bounds_predictions(smallq_hits,model,use_meanshift)
    if ~exist('use_meanshift','var')
       use_meanshift=false; 
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%  Compute the object bounds Hough vote of each poselet hit and cluster them using
    %%%  agglomerative clustering
    %%%%%%%%%%%%%%%%%%%%%%%%%%
    if 0
%         bounds_hits = smallq_hits;
%         for i=1:length(smallq_hits.score)
%             [bounds,angle] = predict_bounds(smallq_hits.bounds(i,:), smallq_hits.angle(i), model.hough_votes(smallq_hits.poselet_id(i)));
%             bounds_hits.bounds(i,:) = bounds;
%             bounds_hits.angle(i,:) = angle;
%         end
%         weights = bounds_hits.score./sum(bounds_hits.score);
%         bounds = sum(bounds_hits.bounds.*[weights weights weights weights],1);
    else
        for i=1:smallq_hits.size
           bounds(i,:) =  predict_bounds(smallq_hits.bounds(i,:),smallq_hits.angle(i),model.hough_votes(smallq_hits.poselet_id(i)));
        end

        hits_scale = smallq_hits.bounds(:,3);
        sigma = reshape([model.hough_votes(smallq_hits.poselet_id).obj_bounds_var],4,[])'.*repmat(hits_scale, 1,4);
        xmin = get_meanshift_mode(bounds(:,1),sigma(:,1),smallq_hits.score,use_meanshift);
        ymin = get_meanshift_mode(bounds(:,2),sigma(:,2),smallq_hits.score,use_meanshift);
        xmax = get_meanshift_mode(bounds(:,1)+bounds(:,3),sigma(:,3),smallq_hits.score,use_meanshift);
        ymax = get_meanshift_mode(bounds(:,2)+bounds(:,4),sigma(:,4),smallq_hits.score,use_meanshift);

        bounds = [xmin ymin xmax-xmin ymax-ymin];        
    end
    bounds_predictions = hit_records(bounds,0,score_hypothesis(smallq_hits,model),0,smallq_hits.image_id(1));
end


%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Predict object bounds from poselet bounds (this is copied from
%%%  poselet_detection folder)
%%%%%%%%%%%%%%%%%%%%%%%%%%

function [bounds,angle] = predict_bounds(poselet_bounds, poselet_angle, poselet2bounds)
    % Given part hits generates a list of torso predictions for each image

    scale = min(poselet_bounds(3:4)); % The poselet normalized coords go from -0.5 to 0.5 along the shorter dimension
    image2poselet_ctr = poselet_bounds(1:2)+poselet_bounds(3:4)/2;
    rad_angle = poselet_angle*pi/180;
    poselet_rot = [cos(rad_angle) sin(rad_angle); -sin(rad_angle) cos(rad_angle)];

    scaled_bounds = poselet2bounds.obj_bounds * scale;
    poselet2bounds_ctr = scaled_bounds(1:2) + scaled_bounds(3:4)/2;
    bounds_dims = scaled_bounds(3:4);

    image2bounds_ctr = image2poselet_ctr + poselet2bounds_ctr*poselet_rot;        
    bounds = [image2bounds_ctr - bounds_dims/2 bounds_dims];
    angle = poselet_angle;
end


function score = score_hypothesis(poselet_hits,model)
    if isfield(model,'boosted')
        features = zeros(max([poselet_hits.poselet_id; model.boosted.poselet']),1);
        features(poselet_hits.poselet_id) = poselet_hits.score;
        
        score = 0;
        for i=1:length(model.boosted.poselet)
           if features(model.boosted.poselet(i))>=model.boosted.thresh(i)
               score = score + model.boosted.alpha(i);
           end
        end
    else
        % max margin
        score = sum(poselet_hits.score.*model.wts(poselet_hits.poselet_id));
    end
end
