function poselet_hits = detect_poselets_in_image(img, model)
global config;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Given an RGB uint8 image returns the locations and scores of all objects
%%% in the image (bounds_predictions), of all poselet hits (poselet_hits)
%%% and, optionally for mammals, of all torso locations (torso_predictions)
%%%
%%% Copyright (C) 2009, Lubomir Bourdev and Jitendra Malik.
%%% This code is distributed with a non-commercial research license.
%%% Please see the license file license.txt included in the source directory.
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if config.DEBUG>0
    config.DEBUG_IMG = img;
end

fprintf('Computing pyramid HOG... ');
total_start_time=clock;
phog=image2phog(img);
fprintf('Done in %4.2f secs.\n',etime(clock,total_start_time));

fprintf('Detecting poselets... ');
start_time=clock;
poselet_hits = nonmax_suppress_hits(detect_poselets(phog,model.svms));
poselet_hits.score = -poselet_hits.score.*model.logit_coef(poselet_hits.poselet_id,1)-model.logit_coef(poselet_hits.poselet_id,2);
poselet_hits.score = 1./(1+exp(-poselet_hits.score));
[srt,srtd]=sort(poselet_hits.score,'descend');
poselet_hits = poselet_hits.select(srtd);
fprintf('Done in %4.2f secs.\n',etime(clock,start_time));
           