
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Demo file that loads an image, finds the people and draws bounding
%%% boxes around them.
%%%
%%% Copyright (C) 2009, Lubomir Bourdev and Jitendra Malik.
%%% This code is distributed with a non-commercial research license.
%%% Please see the license file license.txt included in the source directory.
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

time=clock;
detection_config;

faster_detection = false;  % Set this to false to run slower but higher quality
interactive_visualization = false; % Enable browsing the results
enable_bigq = true; % don't you dare turn this on!

if faster_detection
    disp('Warning: Using parameters optimized for speed over accuracy');
    config.DETECTION_IMG_MIN_NUM_PIX = 500^2;  % if the number of pixels in a detection image is < DETECTION_IMG_SIDE^2, scales up the image to meet that threshold
    config.DETECTION_IMG_MAX_NUM_PIX = 750^2;  
    config.PYRAMID_SCALE_RATIO = 2;
end

% Loads the SVMs for each poselet and the Hough voting params
%load('poselets_model06.16.10.mat'); % model, label_masks, poselet_thumbs
model=load('poselets_model06.16.10.mat');
model=model.model;
if ~enable_bigq
   model =rmfield(model,'bigq_weights');
   model =rmfield(model,'bigq_logit_coef');
end

im1.image_file{1}='test.jpg';
img = imread(im1.image_file{1});
[bounds_predictions,poselet_hits,torso_predictions]=detect_objects_in_image(img,model);


if ~interactive_visualization
%    display_thresh=20; % detection rate vs false positive rate threshold
    if enable_bigq
        display_thresh=50; % detection rate vs false positive rate threshold
    else
        display_thresh=4; 
    end
    imshow(img);
    bounds_predictions.select(bounds_predictions.score>display_thresh).draw_bounds;
    torso_predictions.select(bounds_predictions.score>display_thresh).draw_bounds('blue');
else
    disp('Entering interactive visualization. See README.txt for instructions');
    visualize_detected_objects(poselet_thumbs,label_masks,poselet_hits,torso_predictions,bounds_predictions,model,im1);   
end