function pav = hits2pav(hits_in_img,model,I,bbox,param)
    [h,w,nch] = size(I);
    predicted_bounds = zeros(hits_in_img.size,4);
    for j = 1:hits_in_img.size
        pid = hits_in_img.poselet_id(j);
        predicted_bounds(j,:) = predict_bounds(hits_in_img.bounds(j,:),0,model.hough_votes(pid));
    end
    % find the matching scores and detections
    
    hyp_overlaps = match_hyps_to_box(predicted_bounds,bbox,w,h);
    pav    = zeros(1, length(model.selected_p));

    idx = find(hyp_overlaps > param.OVERLAP_THRESH);
    for j = 1:length(idx)
        s = hits_in_img.score(idx(j));
        pid = hits_in_img.poselet_id(idx(j));
        pav(pid) = pav(pid)+ s;
    end
end


% given a set of hits in an image and a bounding box
% returns the overlaps of each of the hits to the box
function overlaps = match_hyps_to_box(hyps,box,w,h)
    
    if(isvector(hyps))
        rr = [hyps.rect]; 
        bounds = reshape(rr,4,length(hyps)); 
        bounds = bounds';
    else
        bounds = hyps;
        bounds(:,3:4)=bounds(:,1:2) + bounds(:,3:4);
    end
    
    %clip the bounds to the image bounds
    bounds(:,1) = max(0,bounds(:,1));
    bounds(:,3) = min(w,bounds(:,3));
    bounds(:,2) = max(0,bounds(:,2));
    bounds(:,4) = min(h,bounds(:,4));
    
    %w,h format
    bounds(:,3:4) = bounds(:,3:4) - bounds(:,1:2);
    
    %for each box returns the overlap to the box
    overlaps   = rectint(bounds,box);
    areas      = bounds(:,3).*bounds(:,4);
    unionareas = areas + box(3)*box(4) - overlaps;
    overlaps = overlaps./unionareas;
end

% predict bounds given
function [bounds,angle] = predict_bounds(poselet_bounds, poselet_angle, poselet2bounds)
   % Given part hits generates a list of torso predictions for each image

   scale = min(poselet_bounds(3:4)); % The poselet normalized coords go from -0.5 to 0.5 along the shorter dimension
   image2poselet_ctr = poselet_bounds(1:2)+poselet_bounds(3:4)/2;
   rad_angle = poselet_angle*pi/180;
   poselet_rot = [cos(rad_angle) sin(rad_angle); -sin(rad_angle) cos(rad_angle)];

   scaled_bounds = poselet2bounds.obj_bounds * scale;
   poselet2bounds_ctr = scaled_bounds(1:2) + scaled_bounds(3:4)/2;
   bounds_dims = scaled_bounds(3:4);

   image2bounds_ctr = image2poselet_ctr + poselet2bounds_ctr*poselet_rot;
   bounds = [image2bounds_ctr - bounds_dims/2 bounds_dims];
   angle = poselet_angle;
end
