%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Demo file that loads an image and finds the actions of the people 
%%% specified with a list of bounding boxes around them.
%%%
%%% NOTE : The model is using just the Poselet Activation Vector (PAV
%%% scores, Table 1 in the paper. The poselets are trained on the action
%%% images only using annotations collected on AMT.
%%%
%%% Copyright (C) 2011, Subhransu Maji, Lubomir Bourdev, Jitendra Malik
%%% This code is distributed with a non-commercial research license.
%%% Please see the license file license.txt included in the source directory.
%%%
%%% Please cite these papers if you use this code: 
%%% 
%%% Action recognition using a distributed representation of pose and
%%% appearance, Subhransu Maji, Lubomir Bourdev and Jitendra Malik, CVPR 2011.
%%% 
%%% Detecting people using mutually consistent poselet activations, 
%%% Lubomir Bourdev, Subhransu Maji, Thomas Brox and Jitendra Malik, ECCV
%%% 2010.
%%% 
%%% Author : Subhransu Maji  Date : March 26, 2011
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% set paths/load models
addpath poselet_detection;  

detection_config;

% load poselets (these are trained on VOC 10 action images)
load('release-data/model1200.mat');
model = output;

% load action prediction models (only PAV model, no object/context)
load('release-data/actionmodel.mat');

%% parameters for detection/pose estimation

faster = false; % set it to true for faster but less accurate predictions
if faster
    fprintf('warning : faster detection enabled.\n');
    config.PYRAMID_SCALE_RATIO = 2;
end

% overlap thereshold for consitent poselet detection
pavparam.OVERLAP_THRESH = 0.2;                           % don't change

%% specify and image and bounding boxes 
I = imread('2010_006207.jpg');load('2010_006207.mat');          
%% run the pose estimation algorithm
actionscores=image2action(I,bbox,model,pavparam,W,W2);
%% display the predictions
figure(1); clf;
for i = 1:size(bbox,1),
    imshow(I); 
    % draw the bounding box
    rectangle('position',bbox(i,:),'EdgeColor','y');
    rectangle('position',bbox(i,:)+[1 1 -2 -2],'EdgeColor','m');
    %show the top 3 actions and scores
    [score,idx] = sort(actionscores(:,i),'descend');
    titlestr = '';
    for s = 1:3, 
        titlestr = sprintf('%s   %s:%.2f',titlestr,actionlabels{idx(s)},score(s));
    end
    title(titlestr);
    pause;
end