(***********************************************************************)
(*                                                                     *)
(*      Dr. William T. Verts -- April 30, 1996                         *)
(*                                                                     *)
(*      Basic Code Warrior Pascal graphics demo                        *)
(*      Most of this is "magic incantations that I pulled from         *)
(*      from the Code Warrior on-line documentation, then              *)
(*      reduced to the "minimum" (?) essence.  Have fun!               *)
(*                                                                     *)
(***********************************************************************)

Program Test ;

Uses
        Fonts,          
        Windows,                { NewCWindow in here }
{       Menus,          }
        Types,                  { Rect, OSErr in here }
        Events,                 { Button in here }
{       ToolUtils,      }
{       Palettes,       }
{       Memory,         }
{       Devices,        }
        Processes,              { ExitToShell in here }
        OSUtils,                { SysEnvRec, SysEnvirons in here }
{       TextEdit,       }
{       Dialogs,        }
        QuickDraw ;
        
(***********************************************************************)
        
Var     qd              : QDGlobals     ; (* QuickDraw                 *)
        windRect        : Rect          ; (* Rectangle for main window *)
        error           : OSErr         ; (* Error flag                *)
        theWorld        : SysEnvRec     ; (* Gets system environment   *)
        myWindow        : WindowPtr     ; (* The window we draw in     *)
        
(***********************************************************************)
(* Paint a square block centered at <X,Y>, radius R, in current color  *)
        
Procedure Block (X,Y,R:Integer) ;
    Var YY : Integer ;
Begin   (***)
        For YY := Y-R To Y+R Do
                Begin   (***)
                        MoveTo  (X-R, YY) ;
                        LineTo  (X+R, YY) ;
                End ;
End ;

(***********************************************************************)
(* Paint a square box centered at <X,Y>, radius R, in current color    *)

Procedure Box (X,Y,R:Integer) ;
Begin   (***)
        MoveTo  (X-R, Y-R) ;
        LineTo  (X+R, Y-R) ;
        LineTo  (X+R, Y+R) ;
        LineTo  (X-R, Y+R) ;
        LineTo  (X-R, Y-R) ;
End ;

(***********************************************************************)
(* Pick a random drawing color (colors are 2 bytes: [0..65535])        *)

Procedure Random_Color ;
    Var C       : RGBColor ;
Begin   (***)
        With C Do
                Begin   (***)
                        red     := Random;
                        green   := Random;
                        blue    := Random;
                End ;
        
        RGBForeColor (C) ; (* Set the current drawing color *)
End ;

(***********************************************************************)
(* Plot a square with random size & color at a random location         *)

Procedure Random_Block ;
    Var X, Y, R : Integer ;
Begin   (***)
        X       := Abs(Random) Mod 1024 ;
        Y       := Abs(Random) Mod 1024 ;
        R       := Abs(Random) Mod 64 + 10 ;
        Random_Color ;
        Block   (X, Y, R) ;
        Random_Color ;
        Box     (X, Y, R) ;
End ;
        
(***********************************************************************)
(***********************************************************************)
(***********************************************************************)

Begin   (*!*)
        (*--------------------------------*)
        (* Detect the presence of color   *)
        (* QuickDraw routines.  Exit if   *)
        (* they are not present.          *)
        (*--------------------------------*)

        error := SysEnvirons(1, theWorld);

        If Not theWorld.hasColorQD Then
                BEGIN
                        SysBeep (50);
                        ExitToShell;
                END;

        (*--------------------------------*)
        (* Initialize graphics stuff      *)
        (*--------------------------------*)

        InitGraf        (@qd.thePort) ;
        InitFonts       ;
        InitWindows     ;
{       InitMenus       ;       }
{       TEInit          ;       }
{       InitDialogs     (NIL) ; }
        InitCursor      ;

        (*--------------------------------*)
        (* Fetch current screen size,     *)
        (* narrow it by 50 pixels in X&Y, *)
        (* then build a window and make   *)
        (* it active.                     *)
        (*--------------------------------*)

        windRect        := qd.screenBits.bounds ;       (* Fetch the screen size *)
        InsetRect       (windRect, 50, 50) ;            (* Narrow the rectangle  *)
        
        myWindow        := NewCWindow(                  (* Build a new Window:   *)
                                      NIL,              (*    I don't know       *)
                                      windRect,         (*    The dimensions     *)
                                      'Hello World',    (*    The Window Title   *)
                                      TRUE,             (*    I don't know       *)
                                      documentProc,     (*    I don't know       *)
                                      Pointer(-1),      (*    I don't know       *)
                                      FALSE,            (*    I don't know       *)
                                      0                 (*    I don't know       *)
                                     ) ;
                                     
        SetPort         (myWindow) ;                    (* Make Window Active    *)
        
        (*--------------------------------*)
        (* Main drawing part.             *)
        (*--------------------------------*)

        Repeat  (***)                                   (* Draw a random block   *)
                Random_Block ;                          (* Until the Mouse       *)
        Until Button ;                                  (* Button is hit.        *)

        (*--------------------------------*)
        (* Deallocate the window          *)
        (*--------------------------------*)

        DisposeWindow (myWindow) ;                      (* Nuke drawing window   *)
End.
